/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.chat;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxChatGroupItem;
import org.tio.sitexxx.service.model.main.WxChatItems;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxFriendMsg;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.atom.AbsTxAtom;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.chat.GroupService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.utils.SystemTimer;
import org.tio.utils.Threads;
import org.tio.utils.cache.ICache;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.LockUtils;

public class ChatMsgService {
    private static Logger log = LoggerFactory.getLogger(ChatMsgService.class);
    public static final ChatMsgService me = new ChatMsgService();
    static final ICache CHAT_FOUCUS_CACHE = Caches.getCache(CacheConfig.CHAT_ON_FOCUS_3);
    static final ICache CHAT_FOUCUS_DEVICE_CACHE = Caches.getCache(CacheConfig.CHAT_ON_FOCUS_DEVICE_2);
    public static Long MSG_BACK_MAX_TIME = ConfService.getLong("wx.msg.back.max.time", 120000L);

    public Ret msgOper(User curr, Long chatlinkid, Byte oper, String mids, Byte chatmode) {
        if (chatlinkid == null || oper == null || StrUtil.isBlank((CharSequence)mids)) {
            return RetUtils.invalidParam();
        }
        if (Objects.equals(chatmode, (byte)1)) {
            return this.p2pMsgOper(curr, chatlinkid, oper, mids);
        }
        return this.groupMsgOper(curr, chatlinkid, oper, mids);
    }

    public Ret p2pMsgOper(User curr, Long chatlinkid, Byte oper, String mids) {
        WxChatUserItem chatUserItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (!ChatService.friendExistChat(chatUserItem)) {
            return RetUtils.noExistParam();
        }
        Ret ret = null;
        switch (oper) {
            case 1: {
                ret = FriendService.me.delMsg(chatUserItem, mids);
                break;
            }
            case 9: {
                ret = FriendService.me.backMsg(chatUserItem, mids);
                break;
            }
            case 99: {
                ret = RetUtils.okOper();
                break;
            }
            default: {
                return RetUtils.noImplement();
            }
        }
        return ret;
    }

    public Ret groupMsgOper(User curr, Long chatlinkid, Byte oper, String mids) {
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(chatlinkid);
        Ret ret = null;
        switch (oper) {
            case 1: {
                ret = GroupService.me.delMsg(groupItem, mids);
                break;
            }
            case 9: {
                ret = GroupService.me.backMsg(groupItem, mids);
                break;
            }
            case 99: {
                ret = RetUtils.okOper();
                break;
            }
            default: {
                return RetUtils.noImplement();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Ret onFocus(User curr, Long chatlinkid, Long groupid, Byte chatmode, Byte devicetype, Integer ipid) {
        if (Objects.equals(devicetype, Devicetype.IOS.getValue()) || Objects.equals(devicetype, Devicetype.ANDROID.getValue())) {
            devicetype = Devicetype.APP.getValue();
        }
        String key = curr.getId() + "_" + devicetype;
        FocusVo focusVo = new FocusVo();
        focusVo.setUid(curr.getId());
        focusVo.setChatlinkid(chatlinkid);
        focusVo.setDevicetype(devicetype);
        focusVo.setChatmode(chatmode);
        focusVo.setIpid(ipid);
        focusVo.setGroupid(groupid);
        ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            FocusVo old;
            Serializable object = CHAT_FOUCUS_CACHE.get(key);
            if (object != null && Objects.equals((old = (FocusVo)object).getChatmode(), (byte)2)) {
                ChatService.me.updateFocus(old.getGroupid(), old.getUid(), (byte)2);
            }
            CHAT_FOUCUS_CACHE.put(key, (Serializable)focusVo);
            if (Objects.equals(chatmode, (byte)2)) {
                ChatService.me.updateFocus(groupid, curr.getId(), (byte)1);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        Ret ret = ChatMsgService.beforeFocus(curr.getId(), chatlinkid, ipid, devicetype);
        return ret;
    }

    public static Ret joinDeal(FocusVo focusVo) {
        int many;
        Serializable object;
        String key = focusVo.getUid() + "_" + focusVo.getDevicetype();
        if (!Objects.equals(focusVo.getDevicetype(), Devicetype.APP.getValue())) {
            key = key + "_" + focusVo.getChannelid();
        }
        if ((object = CHAT_FOUCUS_CACHE.get(key)) != null) {
            int many2;
            CHAT_FOUCUS_CACHE.remove(key);
            FocusVo old = (FocusVo)object;
            if (Objects.equals(old.getChatmode(), (byte)2) && (many2 = ChatMsgService.manyFocus(old.getUid(), old.getRchatlinkid(), focusVo.getDevicetype())) == 0) {
                ChatService.me.updateFocus(old.getGroupid(), old.getUid(), (byte)2);
            }
        }
        CHAT_FOUCUS_CACHE.put(key, (Serializable)focusVo);
        if (Objects.equals(focusVo.getChatmode(), (byte)2) && (many = ChatMsgService.manyFocus(focusVo.getUid(), focusVo.getRchatlinkid(), focusVo.getDevicetype())) == 0) {
            ChatService.me.updateFocus(focusVo.getGroupid(), focusVo.getUid(), (byte)1);
        }
        if (!Objects.equals(focusVo.getDevicetype(), Devicetype.APP.getValue())) {
            String devicekey = focusVo.getUid() + "_" + focusVo.getDevicetype();
            Serializable deviceObject = CHAT_FOUCUS_DEVICE_CACHE.get(devicekey);
            if (deviceObject != null) {
                HashMap deviceMap = (HashMap)deviceObject;
                deviceMap.put(focusVo.getChannelid(), focusVo.getRchatlinkid());
            } else {
                HashMap<String, Long> deviceMap = new HashMap<String, Long>();
                deviceMap.put(focusVo.getChannelid(), focusVo.getRchatlinkid());
                CHAT_FOUCUS_DEVICE_CACHE.put(devicekey, deviceMap);
            }
        }
        return ChatMsgService.beforeFocus(focusVo.getUid(), focusVo.getChatlinkid(), focusVo.getIpid(), focusVo.getDevicetype());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void refreshFocus(User curr, Byte devicetype) {
        String key = curr.getId() + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                CHAT_FOUCUS_CACHE.remove(key);
                CHAT_FOUCUS_CACHE.put(key, object);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDeal(FocusVo focusVo) {
        String devicekey;
        Serializable deviceObject;
        Serializable object;
        String key = focusVo.getUid() + "_" + focusVo.getDevicetype();
        if (!Objects.equals(focusVo.getDevicetype(), Devicetype.APP.getValue())) {
            key = key + "_" + focusVo.getChannelid();
        }
        if ((object = CHAT_FOUCUS_CACHE.get(key)) != null) {
            CHAT_FOUCUS_CACHE.remove(key);
            CHAT_FOUCUS_CACHE.put(key, object);
        }
        if (!Objects.equals(focusVo.getDevicetype(), Devicetype.APP.getValue()) && (deviceObject = CHAT_FOUCUS_DEVICE_CACHE.get(devicekey = focusVo.getUid() + "_" + focusVo.getDevicetype())) != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_DEVICE_CACHE.getCacheName() + "_" + devicekey), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                CHAT_FOUCUS_DEVICE_CACHE.remove(devicekey);
                CHAT_FOUCUS_CACHE.put(devicekey, deviceObject);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FocusVo getFocus(String uid, Byte devicetype, String cid) {
        Serializable object;
        String key = uid + "_" + devicetype;
        if (StrUtil.isNotBlank((CharSequence)cid)) {
            key = key + "_" + cid;
        }
        if ((object = CHAT_FOUCUS_CACHE.get(key)) != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
            readLock.lock();
            try {
                FocusVo focusVo = (FocusVo)object;
                return focusVo;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Long> getFocusDeviceMap(String uid, Byte devicetype) {
        String key = uid + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_DEVICE_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
            readLock.lock();
            try {
                HashMap hashMap = (HashMap)object;
                return hashMap;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Ret leaveChat(User curr, Byte devicetype) {
        String key = curr.getId() + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                FocusVo focusVo = (FocusVo)object;
                if (Objects.equals(focusVo.getChatmode(), (byte)2)) {
                    ChatService.me.updateFocus(focusVo.getGroupid(), focusVo.getUid(), (byte)2);
                }
                CHAT_FOUCUS_CACHE.remove(key);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
        return RetUtils.okOper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leaveDeal(FocusVo leave) {
        String devicekey;
        Serializable deviceObject;
        Serializable object;
        String key = leave.getUid() + "_" + leave.getDevicetype();
        if (!Objects.equals(leave.getDevicetype(), Devicetype.APP.getValue())) {
            key = key + "_" + leave.getChannelid();
        }
        if ((object = CHAT_FOUCUS_CACHE.get(key)) != null) {
            int many;
            CHAT_FOUCUS_CACHE.remove(key);
            FocusVo focusVo = (FocusVo)object;
            if (Objects.equals(focusVo.getChatmode(), (byte)2) && (many = ChatMsgService.manyFocus(focusVo.getUid(), focusVo.getRchatlinkid(), leave.getDevicetype())) == 0) {
                ChatService.me.updateFocus(focusVo.getGroupid(), focusVo.getUid(), (byte)2);
            }
        }
        if (!Objects.equals(leave.getDevicetype(), Devicetype.APP.getValue()) && (deviceObject = CHAT_FOUCUS_DEVICE_CACHE.get(devicekey = leave.getUid() + "_" + leave.getDevicetype())) != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_DEVICE_CACHE.getCacheName() + "_" + devicekey), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                if (deviceObject != null) {
                    HashMap deviceMap = (HashMap)deviceObject;
                    deviceMap.remove(leave.getChannelid());
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public static int manyFocus(String uid, Long chatlinkid, Byte devicetype) {
        HashMap<String, Long> h5;
        Long existChatLinkid;
        HashMap<String, Long> pc;
        FocusVo app;
        int i = 0;
        if (!Objects.equals(devicetype, Devicetype.APP.getValue()) && (app = me.getFocus(uid, Devicetype.APP.getValue(), "")) != null && Objects.equals(app.getRchatlinkid(), chatlinkid)) {
            ++i;
        }
        if (!Objects.equals(devicetype, Devicetype.PC.getValue()) && (pc = me.getFocusDeviceMap(uid, Devicetype.PC.getValue())) != null) {
            for (String key : pc.keySet()) {
                existChatLinkid = pc.get(key);
                if (!Objects.equals(existChatLinkid, chatlinkid)) continue;
                ++i;
                break;
            }
        }
        if (!Objects.equals(devicetype, Devicetype.H5.getValue()) && (h5 = me.getFocusDeviceMap(uid, Devicetype.H5.getValue())) != null) {
            for (String key : h5.keySet()) {
                existChatLinkid = h5.get(key);
                if (!Objects.equals(existChatLinkid, chatlinkid)) continue;
                ++i;
                break;
            }
        }
        return i;
    }

    public Ret p2pMsgList(Long chatlinkid, String uid, Long startmid, Long endmid) {
        long currTime = SystemTimer.currentTimeMillis();
        Byte type = 1;
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null || !Objects.equals(items.getChatmode(), (byte)1)) {
            return RetUtils.invalidParam();
        }
        if (!Objects.equals(items.getUid(), uid)) {
            return RetUtils.grantError();
        }
        String key = items.getFidkey();
        if (StrUtil.isBlank((CharSequence)key)) {
            return RetUtils.versionError();
        }
        if (startmid == null && endmid == null) {
            ListWithLock<WxFriendMsg> listWithLock = FriendService.me.getP2PMsgList(chatlinkid);
            type = 1;
            long endtime = SystemTimer.currentTimeMillis();
            long useTime = endtime - currTime;
            if (useTime > 500L) {
                log.error("\u79c1\u804a\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
            }
            if (listWithLock != null) {
                return RetUtils.okData(listWithLock.getObj());
            }
            return RetUtils.okData(new ArrayList());
        }
        if (startmid != null) {
            List<WxFriendMsg> msglistList = FriendService.me.getOtherP2PMsgList(chatlinkid, startmid);
            type = 2;
            long endtime = System.currentTimeMillis();
            long useTime = endtime - currTime;
            if (useTime > 500L) {
                log.error("\u79c1\u804a\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
            }
            if (msglistList != null) {
                return RetUtils.okData(msglistList);
            }
            return RetUtils.okData(new ArrayList());
        }
        List<WxFriendMsg> msglistList = FriendService.me.getSynP2PMsgList(chatlinkid, endmid);
        type = 3;
        long endtime = System.currentTimeMillis();
        long useTime = endtime - currTime;
        if (useTime > 500L) {
            log.error("\u79c1\u804a\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
        }
        if (msglistList != null) {
            return RetUtils.okData(msglistList);
        }
        return RetUtils.okData(new ArrayList());
    }

    public Ret groupMsgList(Long chatlinkid, String uid, Long startmid, Long endmid) {
        long currTime = System.currentTimeMillis();
        Byte type = 1;
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null || !Objects.equals(items.getChatmode(), (byte)2)) {
            return RetUtils.invalidParam();
        }
        if (!Objects.equals(items.getUid(), uid)) {
            return RetUtils.grantError();
        }
        if (startmid == null && endmid == null) {
            type = 1;
            ArrayList<WxGroupMsg> list = GroupService.me.getGroupCacheMsgList(chatlinkid);
            long endtime = System.currentTimeMillis();
            long useTime = endtime - currTime;
            if (useTime > 500L) {
                log.error("\u7fa4\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
            }
            if (list != null) {
                return RetUtils.okData(list);
            }
            return RetUtils.okData(new ArrayList());
        }
        if (startmid != null) {
            type = 2;
            List<WxGroupMsg> msglistList = GroupService.me.getOtherGroupMsgList(chatlinkid, startmid);
            long endtime = System.currentTimeMillis();
            long useTime = endtime - currTime;
            if (useTime > 500L) {
                log.error("\u7fa4\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
            }
            if (msglistList != null) {
                return RetUtils.okData(msglistList);
            }
            return RetUtils.okData(new ArrayList());
        }
        type = 3;
        List<WxGroupMsg> msglistList = GroupService.me.getSynGroupMsgList(chatlinkid, endmid);
        long endtime = System.currentTimeMillis();
        long useTime = endtime - currTime;
        if (useTime > 500L) {
            log.error("\u7fa4\u6d88\u606f\u67e5\u8be2\u6162\uff0c\u6761\u4ef6\uff1atype:{},usetime:{},uid:{},chatlinkid:{}", new Object[]{type, useTime, uid, chatlinkid});
        }
        if (msglistList != null) {
            return RetUtils.okData(msglistList);
        }
        return RetUtils.okData(new ArrayList());
    }

    public Ret afterSendFriendChatMsg(WxFriendMsg msg, User user, Long chatlinkid, Byte readflag, Byte toreadflag, Short notreadcount, Byte viewflag) {
        if (chatlinkid == null) {
            log.error("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u804a\u5929\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u804a\u5929\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        if (user == null && (user = UserService.ME.getById(msg.getUid())) == null) {
            log.error("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u6d88\u606f\u53d1\u9001\u7528\u6237\u4e0d\u5b58\u5728");
            return RetUtils.failMsg("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u6d88\u606f\u53d1\u9001\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)user.getId()).set((Object)"fromnick", (Object)user.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys());
        if (readflag != null) {
            params.set((Object)"readflag", (Object)readflag);
            if (Objects.equals(readflag, (byte)1)) {
                params.set((Object)"readnull", (Object)1);
            } else if (notreadcount != null && Objects.equals((byte)2, msg.getSendbysys())) {
                params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId());
            }
        }
        if (toreadflag != null) {
            params.set((Object)"toreadflag", (Object)toreadflag);
        }
        if (viewflag != null) {
            params.set((Object)"viewflag", (Object)viewflag);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendP2PMsg", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u540e\u5904\u7406\u4fee\u6539\u5931\u8d25");
        }
        return Ret.ok();
    }

    public Ret afterSendGroupChatMsg(WxGroupMsg msg, Short notreadcount, Byte viewflag) {
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1);
        if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
            params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
        } else if (notreadcount == null) {
            params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
        }
        if (Objects.equals(msg.getSendbysys(), (byte)1)) {
            params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
        }
        if (viewflag != null) {
            params.set((Object)"viewflag", (Object)viewflag);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupMsg", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    public Ret afterSendGroupAtMsg(WxGroupMsg msg, String ats, Short notreadcount, Byte viewflag) {
        if (StrUtil.isBlank((CharSequence)ats)) {
            return Ret.ok().set((Object)"msg", (Object)"\u65e0at\u4fe1\u606f");
        }
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"linkflag", (Object)1);
        params.set((Object)"atnotreadcount", (Object)notreadcount).set((Object)"atnotreadstartmsgid", (Object)msg.getId()).set((Object)"ats", (Object)ats).set((Object)"focusflag", (Object)2).set((Object)"atreadflag", (Object)2);
        if (viewflag != null) {
            params.set((Object)"viewflag", (Object)viewflag);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupAtMsg", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret afterSendGroupById(WxGroupMsg msg, Short notreadcount, Long chatlinkid, Byte viewflag) {
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.queue.lock.." + msg.getGroupid()), WxGroup.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1).set((Object)"id", (Object)chatlinkid);
            if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
                params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
            } else if (notreadcount == null) {
                params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
            }
            if (Objects.equals(msg.getSendbysys(), (byte)1)) {
                params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
            }
            if (viewflag != null) {
                params.set((Object)"viewflag", (Object)viewflag);
            }
            SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupMsgById", (Map)params);
            Db.use((String)"tio_site_main").update(sqlPara);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
        return RetUtils.okOper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret delGroupChatMsg(WxGroupMsg msg, Short notreadcount, Byte viewflag) {
        ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.queue.lock.." + msg.getGroupid()), WxGroup.class);
        ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
        writeLock.lock();
        try {
            Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1).set((Object)"newlink", (Object)2);
            if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
                params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
            } else if (notreadcount == null) {
                params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
            }
            if (Objects.equals(msg.getSendbysys(), (byte)1)) {
                params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
            }
            if (viewflag != null) {
                params.set((Object)"viewflag", (Object)viewflag);
            }
            SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.delGroupChatMsg", (Map)params);
            Db.use((String)"tio_site_main").update(sqlPara);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
        return RetUtils.okOper();
    }

    public static Ret beforeFocus(final String uid, final Long chatlinkid, final Integer ipid, final Byte devicetype) {
        if (chatlinkid == null) {
            log.error("\u7126\u70b9\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u7126\u70b9\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        final WxChatUserItem userItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (userItem == null) {
            return RetUtils.failMsg("\u4f1a\u8bdd\u7d22\u5f15\u4e0d\u5b58\u5728:" + chatlinkid);
        }
        AbsTxAtom focus = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean isGroup;
                Ret read;
                boolean isToRead = false;
                if (userItem.getTochatlinkid() != null) {
                    Ret toread = ChatMsgService.chatToRead(userItem.getTochatlinkid());
                    if (toread.isFail()) {
                        log.info("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u5bf9\u65b9\u5df2\u8bfb\u672a\u53d8\u5316");
                    } else {
                        isToRead = true;
                    }
                }
                if ((read = ChatMsgService.chatRead(chatlinkid, (isGroup = Objects.equals(userItem.getChatmode(), (byte)2)) ? Byte.valueOf((byte)1) : null, isGroup ? Long.valueOf(Long.parseLong(userItem.getBizid())) : null)).isFail()) {
                    log.info("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u5df2\u8bfb\u672a\u53d8\u5316");
                } else if (Objects.equals(userItem.getChatmode(), (byte)1)) {
                    Ret msgRead = ChatMsgService.p2pMsgRead(userItem.getFidkey(), uid, ipid, devicetype);
                    if (msgRead.isFail()) {
                        log.info("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u6d88\u606f\u5df2\u8bfb\u672a\u53d8\u5316");
                    } else {
                        isToRead = true;
                    }
                }
                this.okRet(isToRead);
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_site_main").tx((IAtom)focus);
        if (!tx) {
            return RetUtils.sysError();
        }
        Ret okRet = focus.getRetObj();
        boolean isToRead = (Boolean)RetUtils.getOkTData(okRet);
        if (isToRead) {
            FriendService.me.clearP2pChatCache(userItem.getChatlinkid());
            if (userItem.getTochatlinkid() != null) {
                okRet.set((Object)"touid", (Object)userItem.getBizid());
                okRet.set((Object)"tochatlinkid", (Object)userItem.getTochatlinkid());
                FriendService.me.clearP2pChatCache(userItem.getChatlinkid());
            }
        }
        ChatIndexService.removeChatItemsCache(chatlinkid);
        return okRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ret chatRead(Long chatlinkid, Byte atflag, Long groupid) {
        if (chatlinkid == null) {
            log.error("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        if (groupid == null) {
            Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"readflag", (Object)1);
            if (atflag != null) {
                params.set((Object)"atreadflag", (Object)1);
            }
            SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.chatRead", (Map)params);
            int update = Db.use((String)"tio_site_main").update(sqlPara);
            if (update <= 0) {
                return RetUtils.failMsg("\u5df2\u8bfb\u672a\u53d8\u5316");
            }
        } else {
            ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.queue.lock.." + groupid), WxGroup.class);
            ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
            writeLock.lock();
            try {
                Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"readflag", (Object)1);
                if (atflag != null) {
                    params.set((Object)"atreadflag", (Object)1);
                }
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.chatRead", (Map)params);
                int update = Db.use((String)"tio_site_main").update(sqlPara);
                if (update <= 0) {
                    Ret ret = RetUtils.failMsg("\u5df2\u8bfb\u672a\u53d8\u5316");
                    return ret;
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            finally {
                writeLock.unlock();
            }
        }
        return Ret.ok();
    }

    public static Ret chatToRead(Long chatlinkid) {
        if (chatlinkid == null) {
            log.error("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"toreadflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.chatToRead", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u5bf9\u65b9\u5df2\u8bfb\u672a\u53d8\u5316");
        }
        return Ret.ok();
    }

    public WxFriendMsg getLastMsg(String fidKey, String touid) {
        if (StrUtil.isBlank((CharSequence)fidKey) || touid == null) {
            return null;
        }
        WxFriendMsg last = (WxFriendMsg)WxFriendMsg.dao.findFirst("select * from wx_friend_msg where twouid = ? and sigleuid != ?  order by id desc limit 0,1", new Object[]{fidKey, touid});
        return last;
    }

    public static Ret p2pMsgRead(String fidKey, String uid, Integer ipid, Byte devicetype) {
        if (StrUtil.isBlank((CharSequence)fidKey) || uid == null) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"touid", (Object)uid).set((Object)"twouid", (Object)fidKey).set((Object)"readipid", (Object)ipid).set((Object)"readdevice", (Object)devicetype).set((Object)"readflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.p2pMsgRead", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u5df2\u8bfb\u672a\u53d8\u5316");
        }
        return Ret.ok();
    }

    public Ret groupMsgDel(String mids, String uid, Long groupid) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"mids", (Object)mids).set((Object)"groupid", (Object)groupid).set((Object)"yes", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgDel", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return Ret.ok();
    }

    public void rebindGroupMsgDeal(WxChatItems chatItems) {
        Long startMid = chatItems.getLastmsgid();
        if (startMid == null) {
            return;
        }
        Kv params = Kv.by((Object)"uid", (Object)chatItems.getUid()).set((Object)"startMid", (Object)startMid).set((Object)"groupid", (Object)chatItems.getBizid()).set((Object)"yes", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.rebindGroupMsgDeal", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
    }

    public static FocusVo isFocus(String uid, Long chatlinkid) {
        HashMap<String, Long> h5;
        FocusVo app = me.getFocus(uid, Devicetype.APP.getValue(), "");
        if (app != null && Objects.equals(app.getRchatlinkid(), chatlinkid)) {
            return app;
        }
        HashMap<String, Long> pc = me.getFocusDeviceMap(uid, Devicetype.PC.getValue());
        if (pc != null) {
            for (String key : pc.keySet()) {
                Long existChatLinkid = pc.get(key);
                if (!Objects.equals(existChatLinkid, chatlinkid)) continue;
                return me.getFocus(uid, Devicetype.PC.getValue(), key);
            }
        }
        if ((h5 = me.getFocusDeviceMap(uid, Devicetype.H5.getValue())) != null) {
            for (String key : h5.keySet()) {
                Long existChatLinkid = h5.get(key);
                if (!Objects.equals(existChatLinkid, chatlinkid)) continue;
                return me.getFocus(uid, Devicetype.H5.getValue(), key);
            }
        }
        return null;
    }

    public int bakFriendMsg(DateTime dateTime) {
        DateTime dealTime = DateUtil.offsetMonth((Date)dateTime, (int)-3);
        return Db.use((String)"tio_site_main").update("delete FROM wx_friend_msg where createtime <= ?", new Object[]{DateUtil.format((Date)dealTime, (String)"yyyy-MM-dd HH:mm:ss")});
    }

    public void groupMetaStat(final Long groupid, final Long msgid, boolean lock) {
        if (lock) {
            Threads.getGroupExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ReentrantReadWriteLock rwLock = LockUtils.getReentrantReadWriteLock((String)("chat.queue.lock.." + groupid), WxGroup.class);
                    ReentrantReadWriteLock.WriteLock writeLock = rwLock.writeLock();
                    writeLock.lock();
                    try {
                        Db.use((String)"tio_site_main").update("update wx_group_meta set msgcount = msgcount + 1,lastmsgid = ? where groupid = ?", new Object[]{msgid, groupid});
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            });
        } else {
            Db.use((String)"tio_site_main").update("update wx_group_meta set msgcount = msgcount + 1,lastmsgid = ? where groupid = ?", new Object[]{msgid, groupid});
        }
    }

    public void friendMsgMetaStat(final String fidkey, final Long msgid) {
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Db.use((String)"tio_site_main").update("update wx_friend_meta set msgcount = msgcount + 1,lastmsgid = ? where fidkey = ?", new Object[]{msgid, fidkey});
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    public void delFriendMsg(String twouid) {
        Db.use((String)"tio_site_main").update("delete from wx_friend_msg  where twouid = ?", new Object[]{twouid});
    }

    public int bakGroupMsg(DateTime dateTime) {
        DateTime dealTime = DateUtil.offsetMonth((Date)dateTime, (int)-3);
        return Db.use((String)"tio_site_main").update("delete FROM wx_group_msg where createtime <= ?", new Object[]{DateUtil.format((Date)dealTime, (String)"yyyy-MM-dd HH:mm:ss")});
    }

    public int delGroupInvalidMsg() {
        return Db.use((String)"tio_site_main").update("delete from wx_group_msg where groupid not in (select groupid from wx_chat_group_item)");
    }

    public int updateGroupInvalidMsg() {
        return Db.use((String)"tio_site_main").update("update wx_group_msg set `status` = ? where groupid not in (select id from wx_group)", new Object[]{(byte)2});
    }

    public int bakGroupInvalidMsg() {
        return Db.use((String)"tio_site_main").update("INSERT INTO wx_group_msg_bak SELECT *, now() baktime FROM wx_group_msg WHERE groupid not in (select id from wx_group)  and `status` = ?", new Object[]{(byte)1});
    }

    public static interface MsgTemplate {
        public static final String create = "%%% \u9080\u8bf7 ### \u52a0\u5165\u4e86\u7fa4\u804a";
        public static final String join = "%%% \u9080\u8bf7 ### \u52a0\u5165\u4e86\u7fa4\u804a";
        public static final String ownerleave = "%%% \u9000\u51fa\u4e86\u7fa4\u804a\uff0c### \u81ea\u52a8\u6210\u4e3a\u7fa4\u4e3b";
        public static final String leave = "%%% \u9000\u51fa\u4e86\u7fa4\u804a";
        public static final String operkick = "%%% \u5c06 ### \u79fb\u9664\u4e86\u7fa4\u804a";
        public static final String tokick = "### \u88ab %%% \u79fb\u9664\u4e86\u7fa4\u804a";
        public static final String msgback = "%%% \u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f";
        public static final String ownerchange = "%%% \u5c06\u7fa4\u4e3b\u8f6c\u8ba9\u7ed9\u4e86 ###";
        public static final String applyopen = "%%% \u5f00\u542f\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u6240\u6709\u4eba\u90fd\u53ef\u4ee5\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
        public static final String applyclose = "%%% \u5173\u95ed\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u53ea\u6709\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u624d\u80fd\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
        public static final String reviewopen = "%%% \u5f00\u542f\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u524d,\u5fc5\u987b\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u5ba1\u6838\u901a\u8fc7";
        public static final String reviewclose = "%%% \u5173\u95ed\u4e86\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u4e0d\u9700\u8981\u5ba1\u6838";
        public static final String updatenotice = "%%% \u4fee\u6539\u4e86\u7fa4\u516c\u544a:###";
        public static final String updatename = "%%% \u4fee\u6539\u4e86\u7fa4\u540d\u79f0:###";
        public static final String delgroup = "%%% \u89e3\u6563\u4e86\u7fa4";
    }
}

