/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.chat;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxFriendApplyItems;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class FriendApplyService {
    private static Logger log = LoggerFactory.getLogger(FriendApplyService.class);
    public static final FriendApplyService me = new FriendApplyService();

    public Ret applyList(String uid) {
        if (uid == null) {
            log.error("\u83b7\u53d6\u7533\u8bf7\u5217\u8868\uff1a\u65e0\u6548\u7528\u6237");
            return Ret.fail((Object)"msg", (Object)"\u65e0\u6548\u53c2\u6570");
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friendapply.applylist", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        return RetUtils.okList(records);
    }

    public Ret applyInfo(final Integer applyid) {
        if (applyid == null) {
            log.error("\u83b7\u53d6\u7533\u8bf7\u4fe1\u606f\uff1a\u65e0\u6548id");
            return RetUtils.invalidParam();
        }
        ICache cache = Caches.getCache(CacheConfig.WX_FRIEND_APPLY_INFO_1);
        String key = applyid + "";
        Record record = (Record)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<Record>(){

            public Record create() {
                Kv params = Kv.by((Object)"applyid", (Object)applyid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friendapply.applyInfo", (Map)params);
                Record record = Db.use((String)"tio_site_main").findFirst(sqlPara);
                return record;
            }
        });
        return RetUtils.okData(record);
    }

    public void clearApplyCache(Integer applyid) {
        Caches.getCache(CacheConfig.WX_FRIEND_APPLY_INFO_1).remove(applyid + "");
    }

    public Ret applyData(String uid) {
        if (uid == null) {
            log.error("\u83b7\u53d6\u7533\u8bf7\u5217\u8868\uff1a\u65e0\u6548\u7528\u6237");
            return Ret.fail((Object)"msg", (Object)"\u65e0\u6548\u53c2\u6570");
        }
        int count = Db.use((String)"tio_site_main").queryInt("SELECT count(1) num FROM wx_friend_apply_items where touid = ? and `status` = ?", new Object[]{uid, (byte)2});
        return RetUtils.okData(count);
    }

    public int applyInit(String uid, String touid, String greet, Byte autoFlag, Byte status) {
        WxFriendApplyItems applyItems = new WxFriendApplyItems();
        applyItems.setFromuid(uid);
        applyItems.setTouid(touid);
        applyItems.setGreet(greet);
        applyItems.setAutoflag(autoFlag);
        applyItems.setStatus(status);
        applyItems.setReplytime(new Date());
        return applyItems.replaceSave();
    }

    public int applyInit(String uid, String touid, String greet, WxFriendApplyItems applyItems) {
        if (applyItems == null) {
            applyItems = new WxFriendApplyItems();
        }
        applyItems.setFromuid(uid);
        applyItems.setTouid(touid);
        applyItems.setGreet(greet);
        applyItems.setAutoflag((byte)2);
        applyItems.setStatus((byte)2);
        applyItems.setReplytime(new Date());
        return applyItems.replaceSave();
    }

    public int applyInit(String uid, String touid, String greet) {
        return this.applyInit(uid, touid, greet, null);
    }

    public boolean update(Integer applyid, Byte status) {
        WxFriendApplyItems update = new WxFriendApplyItems();
        update.setId(applyid);
        update.setStatus(status);
        boolean updateFlag = update.update();
        if (updateFlag) {
            this.clearApplyCache(applyid);
        }
        return updateFlag;
    }

    public WxFriendApplyItems getById(Integer id) {
        return (WxFriendApplyItems)WxFriendApplyItems.dao.findById(id);
    }

    public Ret removeApply(WxFriendApplyItems items) {
        WxFriendApplyItems old = this.getApply(items.getFromuid(), items.getTouid());
        if (old != null) {
            WxFriendApplyItems.dao.deleteById(old.getId());
            this.clearApplyCache(old.getId());
        }
        return RetUtils.setCode((byte)1);
    }

    public boolean removeApply(String uid, String touid) {
        WxFriendApplyItems old = this.getApply(uid, touid);
        if (old != null) {
            WxFriendApplyItems.dao.deleteById(old.getId());
            this.clearApplyCache(old.getId());
        }
        return true;
    }

    public WxFriendApplyItems getApply(String uid, String touid) {
        Kv params = Kv.by((Object)"fromuid", (Object)uid).set((Object)"touid", (Object)touid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friendapply.findApply", (Map)params);
        WxFriendApplyItems old = (WxFriendApplyItems)WxFriendApplyItems.dao.findFirst(sqlPara);
        return old;
    }
}

