/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.chat;

import cn.jiguang.common.ClientConfig;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.vo.Const;

public class JPushService {
    private static Logger log = LoggerFactory.getLogger(JPushService.class);
    public static final JPushService me = new JPushService();
    private static JPushClient jpushClient = new JPushClient(Const.JPushConfig.MASTERSECRET, Const.JPushConfig.APPKEY, null, ClientConfig.getInstance());

    public static PushPayload initPushAlias(Integer uid, String fromnick, String msg, String chatName, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushAlias(uid, msg, extras, chatName);
    }

    public static PushPayload initPushAlias(List<String> uid, String fromnick, String msg, String chatName, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushAlias(uid, msg, extras, chatName);
    }

    public static PushPayload initPushAlias(Integer uid, String fromnick, String msg, String chatName, Long chatlinkid, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", chatlinkid + "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushAlias(uid, msg, extras, chatName);
    }

    public static PushPayload initPushAlias(Integer uid, String msg, Map<String, String> extras, String title) {
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msg).setTitle(title).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)IosAlert.newBuilder().setTitleAndBody(title, "", msg).build()).addExtras(extras)).build()).build();
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias((String[])new String[]{uid + ""})).setNotification(notification).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        return payload;
    }

    public static PushPayload initPushAlias(List<String> uid, String msg, Map<String, String> extras, String title) {
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msg).setTitle(title).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)IosAlert.newBuilder().setTitleAndBody(title, "", msg).build()).addExtras(extras)).build()).build();
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias(uid)).setNotification(notification).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        return payload;
    }

    public static PushPayload initPushReg(String regid, String fromnick, String msg, String chatName, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushReg(regid, msg, extras, chatName);
    }

    public static PushPayload initPushReg(List<String> regids, String fromnick, String msg, String chatName, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushReg(regids, msg, extras, chatName);
    }

    public static PushPayload initPushReg(String regid, String fromnick, String msg, String chatName, Long chatlinkid, Byte chatmode) {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("chatName", chatName);
        extras.put("nick", fromnick);
        extras.put("text", msg);
        extras.put("chatlinkid", chatlinkid + "");
        if (Objects.equals(chatmode, (byte)2)) {
            msg = fromnick + "\uff1a" + msg;
        }
        return JPushService.initPushReg(regid, msg, extras, chatName);
    }

    public static PushPayload initPushReg(String regid, String msg, Map<String, String> extras, String title) {
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msg).setTitle(title).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)IosAlert.newBuilder().setTitleAndBody(title, "", msg).build()).addExtras(extras)).build()).build();
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId((String[])new String[]{regid})).setNotification(notification).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        return payload;
    }

    public static PushPayload initPushReg(List<String> regids, String msg, Map<String, String> extras, String title) {
        Notification notification = Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msg).setTitle(title).addExtras(extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)IosAlert.newBuilder().setTitleAndBody(title, "", msg).build()).addExtras(extras)).build()).build();
        PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(regids)).setNotification(notification).setOptions(Options.newBuilder().setApnsProduction(true).build()).build();
        return payload;
    }

    public static void send(PushPayload payload, Byte chatmode) {
        try {
            PushResult result = jpushClient.sendPush(payload);
            Thread.sleep(5000L);
            jpushClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

