/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.chat;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.WxSynItem;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.atom.AbsTxAtom;
import org.tio.sitexxx.service.service.chat.ChatMsgService;
import org.tio.sitexxx.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.utils.lock.LockUtils;

public class SynService {
    private static Logger log = LoggerFactory.getLogger(SynService.class);
    public static final SynService me = new SynService();
    final WxSynItem synItemDao = (WxSynItem)new WxSynItem().dao();

    public Ret chat(User user, Byte devicetype, Date syntime) {
        if (user == null) {
            log.error("\u540c\u6b65\u4f1a\u8bdd\u7528\u6237\u4e3a\u7a7a");
            return RetUtils.invalidParam();
        }
        String uid = user.getId();
        WxSynItem synItem = null;
        boolean isAll = true;
        if (syntime != null) {
            isAll = false;
            synItem = this.getSynItem(devicetype, uid, (byte)1);
            if (synItem == null) {
                WxSynItem client;
                synItem = client = this.insertSynTime(devicetype, uid, (byte)3, null, true);
            }
        } else {
            synItem = this.getSynItem(devicetype, uid, (byte)1);
            if (synItem != null && synItem.getSyntime() != null) {
                isAll = false;
            } else {
                WxSynItem createItem = this.getSynItem(devicetype, uid, (byte)2);
                if (createItem != null && createItem.getSyntime() != null) {
                    isAll = false;
                    synItem = createItem;
                }
            }
        }
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        if (isAll) {
            retmap.put("all", (byte)1);
            Kv params = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"viewflag", (Object)1).set((Object)"limit", (Object)5000);
            SqlPara sqlPara = User.dao.getSqlPara("chat.list", (Map)params);
            List records = Db.use((String)"tio_site_main").find(sqlPara);
            retmap.put("chatlist", records);
            if (synItem == null) {
                WxSynItem all = this.insertSynTime(devicetype, uid, (byte)1, null, true);
                retmap.put("synitem", (Object)all);
            } else {
                retmap.put("synitem", (Object)synItem);
            }
            return RetUtils.okData(retmap);
        }
        retmap.put("all", (byte)2);
        if (synItem != null) {
            retmap.put("synitem", (Object)synItem);
        }
        if (syntime != null) {
            retmap.put("clienttime", syntime);
        } else {
            syntime = synItem.getSyntime();
        }
        Kv params = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"viewflag", (Object)1).set((Object)"syntime", (Object)syntime);
        SqlPara sqlPara = User.dao.getSqlPara("syn.synchatlist", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        retmap.put("chatlist", records);
        Kv delParams = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"syntime", (Object)syntime);
        SqlPara delSqlPara = User.dao.getSqlPara("syn.syndelchatlist", (Map)delParams);
        List delList = Db.use((String)"tio_site_main").find(delSqlPara);
        Kv hideparams = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"viewflag", (Object)2).set((Object)"syntime", (Object)syntime);
        SqlPara hidesqlPara = User.dao.getSqlPara("syn.synchatlist", (Map)hideparams);
        List hideRecords = Db.use((String)"tio_site_main").find(hidesqlPara);
        delList.addAll(hideRecords);
        retmap.put("dellist", delList);
        return RetUtils.okData(retmap);
    }

    public Ret ack(final User user, final Integer synid) {
        if (user == null || synid == null) {
            log.error("\u540c\u6b65\u4f1a\u8bdd\u7528\u6237\u4e3a\u7a7a");
            return RetUtils.invalidParam();
        }
        final WxSynItem wxSynItem = (WxSynItem)this.synItemDao.findById(synid);
        if (wxSynItem == null) {
            log.error("\u540c\u6b65\u8bb0\u5f55\u5df2\u6e05\u9664\uff0cuid:{},synid:{}", (Object)user.getId(), (Object)synid);
            return RetUtils.okMsg("\u5df2\u6e05\u9664\u540c\u6b65\u8bb0\u5f55");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                me.insertSynTime(wxSynItem.getDevicetype(), user.getId(), (byte)2, new Date(), true);
                SynService.this.synItemDao.deleteById(synid);
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!tx) {
            return RetUtils.failMsg("ack\u5931\u8d25");
        }
        return RetUtils.okOper();
    }

    public Map<String, Byte> focus(String uid) {
        HashMap<String, Long> h5;
        FocusVo app;
        if (uid == null) {
            log.error("\u540c\u6b65\u7126\u70b9\u7528\u6237\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, Byte> focusMap = new HashMap<String, Byte>();
        HashMap<String, Long> pc = ChatMsgService.me.getFocusDeviceMap(uid, Devicetype.PC.getValue());
        if (pc != null) {
            for (String key : pc.keySet()) {
                Long existChatLinkid = pc.get(key);
                focusMap.put(existChatLinkid + "", (byte)1);
            }
        }
        if ((app = ChatMsgService.me.getFocus(uid, Devicetype.APP.getValue(), "")) != null) {
            focusMap.put(app.getRchatlinkid() + "", (byte)1);
        }
        if ((h5 = ChatMsgService.me.getFocusDeviceMap(uid, Devicetype.H5.getValue())) != null) {
            for (String key : h5.keySet()) {
                Long existChatLinkid = h5.get(key);
                focusMap.put(existChatLinkid + "", (byte)1);
            }
        }
        return focusMap;
    }

    public Map<String, Byte> focusDevice(String uid, Byte devicetype) {
        HashMap<String, Long> h5;
        FocusVo app;
        Long existChatLinkid;
        HashMap<String, Long> pc;
        if (uid == null) {
            log.error("\u540c\u6b65\u7126\u70b9\u7528\u6237\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, Byte> focusMap = new HashMap<String, Byte>();
        if (Objects.equals(devicetype, Devicetype.PC.getValue()) && (pc = ChatMsgService.me.getFocusDeviceMap(uid, Devicetype.PC.getValue())) != null) {
            for (String key : pc.keySet()) {
                existChatLinkid = pc.get(key);
                focusMap.put(existChatLinkid + "", (byte)1);
            }
        }
        if (Objects.equals(devicetype, Devicetype.APP.getValue()) && (app = ChatMsgService.me.getFocus(uid, Devicetype.APP.getValue(), "")) != null) {
            focusMap.put(app.getRchatlinkid() + "", (byte)1);
        }
        if (Objects.equals(devicetype, Devicetype.H5.getValue()) && (h5 = ChatMsgService.me.getFocusDeviceMap(uid, Devicetype.H5.getValue())) != null) {
            for (String key : h5.keySet()) {
                existChatLinkid = h5.get(key);
                focusMap.put(existChatLinkid + "", (byte)1);
            }
        }
        return focusMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCluChatCache(String uid, Long chatlinkid) {
        String key = uid + "";
        HashMap<String, Long> chatcache = null;
        Serializable object = Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).get(key);
        ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).getCacheName() + "_" + key), null);
        ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
        readLock.lock();
        try {
            if (object != null) {
                chatcache = (HashMap<String, Long>)object;
                chatcache.put(chatlinkid + "", chatlinkid);
            } else {
                chatcache = new HashMap<String, Long>();
                chatcache.put(chatlinkid + "", chatlinkid);
                Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).put(key, chatcache);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCluChatCache(String uid) {
        String key = uid + "";
        HashMap chatcache = null;
        Serializable object = Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).get(key);
        ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).getCacheName() + "_" + key), null);
        ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
        readLock.lock();
        try {
            if (object != null) {
                Caches.getCache(CacheConfig.WX_USER_CLU_CHATCACHE_1).remove(key);
                chatcache = (HashMap)object;
                for (String chatStr : chatcache.keySet()) {
                    Long chatlinkid = (Long)chatcache.get(chatStr);
                    Caches.getCache(CacheConfig.WX_FRIEND_MSG_CHAT_5).remove(chatlinkid + "");
                }
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    public WxSynItem insertSynTime(Byte devicetype, String uid, Byte syntype, Date syntime, boolean isreplace) {
        WxSynItem item = new WxSynItem();
        item.setUid(uid);
        item.setSyntype(syntype);
        item.setSyntime(syntime);
        item.setDevicetype(devicetype);
        if (isreplace) {
            item.replaceSave();
        } else {
            item.ignoreSave();
        }
        return item;
    }

    public WxSynItem getSynItem(Byte devicetype, String uid, Byte syntype) {
        return (WxSynItem)this.synItemDao.findFirst("select * from wx_syn_item where uid = ? and devicetype = ? and syntype = ?", new Object[]{uid, devicetype, syntype});
    }

    public void delSynTime(Byte devicetype, String uid) {
        Db.use((String)"tio_site_main").update("delete from wx_syn_item where uid = ? and devicetype = ?", new Object[]{uid, devicetype});
    }
}

