/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.conf;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.model.conf.Conf;
import org.tio.sitexxx.service.model.conf.ConfDev;
import org.tio.utils.lock.LockUtils;

public class ConfService {
    private static Logger log = LoggerFactory.getLogger(ConfService.class);
    public static final ConfService me = new ConfService();
    static final Conf confDao = (Conf)new Conf().dao();
    static final ConfDev confDevDao = (ConfDev)new ConfDev().dao();
    private static Map<String, String> cacheData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<ConfService> clazz = ConfService.class;
        synchronized (ConfService.class) {
            cacheData = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        HashMap<String, String> tempCache = new HashMap<String, String>();
        ArrayList<Conf> list = null;
        try {
            List list2;
            list = confDao.find("select * from conf");
            if (list == null) {
                list = new ArrayList<Conf>();
            }
            if ((list2 = confDevDao.find("select * from conf_dev")) != null) {
                for (ConfDev item : list2) {
                    Conf conf = new Conf();
                    conf.setName(item.getName());
                    conf.setValue(item.getValue());
                    conf.setRemark(item.getRemark());
                    list.add(conf);
                }
            }
            if (list.size() == 0) {
                return;
            }
            for (Conf conf : list) {
                tempCache.put(conf.getName(), conf.getValue());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            cacheData = tempCache;
        }
    }

    public static String getString(String name, String defaultValue) {
        String value;
        if (cacheData == null) {
            try {
                LockUtils.runWriteOrWaitRead((String)ConfService.class.getName(), ConfService.class, () -> {
                    if (cacheData == null) {
                        ConfService.loadData();
                    }
                });
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        if (!StrUtil.isBlank((CharSequence)(value = cacheData.get(name)))) {
            return value;
        }
        return defaultValue;
    }

    public static Integer getInt(String name, Integer defaultValue) {
        String value = ConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Byte getByte(String name, Byte defaultValue) {
        String value = ConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public static Float getFloat(String name, Float defaultValue) {
        String value = ConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Double getDouble(String name, Double defaultValue) {
        String value = ConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static Boolean getBoolean(String name, String defaultValue, String trueValue) {
        String value = ConfService.getString(name, defaultValue);
        return value.equalsIgnoreCase(trueValue);
    }

    public static Boolean getBoolean(String name, String defaultValue) {
        String value = ConfService.getString(name, defaultValue);
        return value.equalsIgnoreCase("true");
    }

    public static Long getLong(String name, Long defaultValue) {
        String value = ConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }
}

