/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.conf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.model.conf.Dict;

public class DictService {
    private static Logger log = LoggerFactory.getLogger(DictService.class);
    public static final DictService me = new DictService();
    static final Dict dictDao = (Dict)new Dict().dao();
    private static String CHILD_DICT_PRE = "child_list_";
    private static Map<String, Object> cacheData = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDict() {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData = new HashMap<String, Object>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<Dict> getChildDictByParentCode(String parentCode) {
        String key = CHILD_DICT_PRE + parentCode;
        Object childDictList = cacheData.get(key);
        if (childDictList == null) {
            Class<Dict> clazz = Dict.class;
            // MONITORENTER : org.tio.sitexxx.service.model.conf.Dict.class
            if (childDictList == null && (childDictList = dictDao.find("select id,name,code,pcode from dict where pcode = ? and status = ? order by orderby", new Object[]{parentCode, (byte)1})) != null) {
                cacheData.put(key, childDictList);
            }
            // MONITOREXIT : clazz
        }
        if (childDictList == null) return null;
        List list = (List)childDictList;
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearChildDictByParent(String parentCode) {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(CHILD_DICT_PRE + parentCode);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDictByCode(String code, String parentCode) {
        Class<Dict> clazz = Dict.class;
        synchronized (Dict.class) {
            cacheData.remove(code);
            cacheData.remove(CHILD_DICT_PRE + parentCode);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Dict getDictByCode(String code) {
        Object dict = cacheData.get(code);
        if (dict == null) {
            Class<Dict> clazz = Dict.class;
            // MONITORENTER : org.tio.sitexxx.service.model.conf.Dict.class
            if (dict == null && (dict = dictDao.findFirst("select id,name,code,pcode,attribute from dict where code = ? and status = ? order by orderby", new Object[]{code, (byte)1})) != null) {
                cacheData.put(code, dict);
            }
            // MONITOREXIT : clazz
        }
        if (dict == null) return null;
        Dict dict2 = (Dict)((Object)dict);
        return dict2;
    }
}

