/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.conf;

import cn.hutool.core.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.model.conf.Httpcache;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.lock.LockUtils;

public class HttpcacheService {
    private static Logger log = LoggerFactory.getLogger(HttpcacheService.class);
    private static final String cacheNamePrefix = "tiosite_httpcache_";
    public static final HttpcacheService me = new HttpcacheService();
    static final Httpcache dao = (Httpcache)new Httpcache().dao();
    private static Map<String, Httpcache> map = null;
    private static List<Httpcache> list = null;
    private static Map<String, CaffeineCache> pathCacheMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<HttpcacheService> clazz = HttpcacheService.class;
        synchronized (HttpcacheService.class) {
            map = null;
            list = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static List<Httpcache> selectAll() {
        List list1 = dao.find("select * from httpcache where status = 1");
        if (list1 != null) {
            for (Httpcache httpcache : list1) {
                String cookies;
                String params;
                String path = httpcache.getPath();
                if (!StrUtil.startWith((CharSequence)path, (CharSequence)"/")) {
                    path = path + "/" + path;
                }
                if (StrUtil.isNotBlank((CharSequence)(params = httpcache.getParams()))) {
                    String[] paramArray = StrUtil.split((CharSequence)params, (CharSequence)",");
                    StrUtil.trim((String[])paramArray);
                    httpcache.setParamArray(paramArray);
                }
                if (StrUtil.isNotBlank((CharSequence)(cookies = httpcache.getCookies()))) {
                    String[] cookieArray = StrUtil.split((CharSequence)cookies, (CharSequence)",");
                    StrUtil.trim((String[])cookieArray);
                    httpcache.setCookieArray(cookieArray);
                }
                Byte uid = httpcache.getUid();
                boolean useUidAsKey = Objects.equals(uid, (byte)1);
                httpcache.setUseUidAsKey(useUidAsKey);
                Byte login = httpcache.getLogin();
                boolean useLoginedAsKey = Objects.equals(login, (byte)1);
                httpcache.setUseLoginedAsKey(useLoginedAsKey);
                String metaClass = httpcache.getMetaclass();
                if (!StrUtil.isNotBlank((CharSequence)metaClass)) continue;
                try {
                    Object httpCacheMeta = Class.forName(metaClass).newInstance();
                    httpcache.setHttpCacheMeta(httpCacheMeta);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        list = list1;
        return list;
    }

    public static List<Httpcache> getAll() {
        if (list == null) {
            HttpcacheService.loadData();
        }
        return list;
    }

    private static void loadData() {
        try {
            LockUtils.runWriteOrWaitRead((String)HttpcacheService.class.getName(), HttpcacheService.class, () -> {
                if (list == null) {
                    HashMap<String, Httpcache> map1 = new HashMap<String, Httpcache>();
                    HashMap<String, CaffeineCache> pathCacheMap1 = new HashMap<String, CaffeineCache>();
                    try {
                        List<Httpcache> list = HttpcacheService.selectAll();
                        if (list != null) {
                            for (Httpcache httpcache : list) {
                                String path = httpcache.getPath();
                                map1.put(path, httpcache);
                                Long timeToLiveSeconds = httpcache.getExpireafterwrite();
                                Long timeToIdleSeconds = httpcache.getExpireafteraccess();
                                CaffeineCache caffeineCache = CaffeineCache.getCache((String)(cacheNamePrefix + path), (boolean)true);
                                if (caffeineCache == null) {
                                    caffeineCache = CaffeineCache.register((String)(cacheNamePrefix + path), (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
                                }
                                pathCacheMap1.put(path, caffeineCache);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    map = map1;
                    pathCacheMap = pathCacheMap1;
                }
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static Httpcache get(String path) {
        if (map == null) {
            HttpcacheService.loadData();
        }
        Httpcache value = map.get(path);
        return value;
    }

    public static ICache getCache(String path) {
        if (pathCacheMap == null) {
            HttpcacheService.loadData();
        }
        ICache value = (ICache)pathCacheMap.get(path);
        return value;
    }
}

