/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.conf;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.service.model.conf.IpBlackList;

public class IpBlackListService {
    private static Logger log = LoggerFactory.getLogger(IpBlackListService.class);
    public static final IpBlackListService me = new IpBlackListService();
    static final IpBlackList dao = IpBlackList.dao;
    private static Map<String, IpBlackList> cacheData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, IpBlackList> getAll() {
        if (cacheData != null) return cacheData;
        Class<IpBlackListService> clazz = IpBlackListService.class;
        synchronized (IpBlackListService.class) {
            if (cacheData != null) return cacheData;
            IpBlackListService.loadData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cacheData;
        }
    }

    public boolean save(String ip, String remark) {
        IpBlackList ipBlackList = new IpBlackList();
        ipBlackList.setIp(StrUtil.trim((CharSequence)ip));
        ipBlackList.setStatus((byte)1);
        ipBlackList.setRemark(StrUtil.trim((CharSequence)remark));
        boolean ret = ipBlackList.save();
        IpBlackListService.clearCache();
        return ret;
    }

    public int delete(String ip, String remark) {
        int ret = Db.use((String)"tio_site_conf").update("update ip_black_list set status = ?, remark = ? where ip = ?", new Object[]{2, remark, ip});
        IpBlackListService.clearCache();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<IpBlackListService> clazz = IpBlackListService.class;
        synchronized (IpBlackListService.class) {
            cacheData = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        HashMap<String, IpBlackList> cacheData1 = new HashMap<String, IpBlackList>();
        ArrayList list = null;
        try {
            list = dao.find("select * from ip_black_list where status=1");
            if (list == null) {
                list = new ArrayList();
                return;
            }
            for (IpBlackList conf : list) {
                cacheData1.put(conf.getIp(), conf);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            cacheData = cacheData1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBlackIp(String ip) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            return false;
        }
        if (cacheData != null) return cacheData.containsKey(ip);
        Class<IpBlackListService> clazz = IpBlackListService.class;
        synchronized (IpBlackListService.class) {
            if (cacheData != null) return cacheData.containsKey(ip);
            IpBlackListService.loadData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cacheData.containsKey(ip);
        }
    }
}

