/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.conf;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.model.conf.IpWhiteList;
import org.tio.sitexxx.service.vo.topic.TopicVo;
import org.tio.utils.lock.LockUtils;

public class IpWhiteListService {
    private static Logger log = LoggerFactory.getLogger(IpWhiteListService.class);
    public static final IpWhiteListService me = new IpWhiteListService();
    static final IpWhiteList dao = (IpWhiteList)new IpWhiteList().dao();
    private static Map<String, IpWhiteList> cacheData = null;

    public boolean save(String ip, String remark) {
        IpWhiteList ipWhiteList = new IpWhiteList();
        ipWhiteList.setIp(ip);
        ipWhiteList.setStatus((byte)1);
        ipWhiteList.setRemark(remark);
        boolean ret = ipWhiteList.save();
        IpWhiteListService.clearCache();
        RTopic topic = RedisInit.get().getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)9));
        topic.publishAsync((Object)topicVo);
        return ret;
    }

    public int delete(String ip, String remark) {
        int ret = Db.use((String)"tio_site_conf").update("update ip_white_list set status = ?, remark = ? where ip = ?", new Object[]{2, remark, ip});
        IpWhiteListService.clearCache();
        RTopic topic = RedisInit.get().getTopic("COMMON_TOPIC");
        TopicVo topicVo = new TopicVo();
        topicVo.setType(Byte.valueOf((byte)9));
        topic.publishAsync((Object)topicVo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<IpWhiteListService> clazz = IpWhiteListService.class;
        synchronized (IpWhiteListService.class) {
            cacheData = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void loadData() throws Exception {
        LockUtils.runWriteOrWaitRead((String)IpWhiteListService.class.getName(), IpWhiteListService.class, () -> {
            if (cacheData == null) {
                HashMap<String, IpWhiteList> cacheData1 = new HashMap<String, IpWhiteList>();
                ArrayList list = null;
                try {
                    list = dao.find("select * from ip_white_list where status=1");
                    if (list == null) {
                        list = new ArrayList();
                        return;
                    }
                    for (IpWhiteList conf : list) {
                        cacheData1.put(conf.getIp(), conf);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    cacheData = cacheData1;
                }
            }
        });
    }

    public static boolean isWhiteIp(String ip) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            return false;
        }
        if (cacheData == null) {
            try {
                IpWhiteListService.loadData();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return cacheData.containsKey(ip);
    }
}

