/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.stat;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.TioThreadLogs;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.main.WxFriendMeta;
import org.tio.sitexxx.service.model.stat.AreaStat;
import org.tio.sitexxx.service.model.stat.TioIpPathAccessStat;
import org.tio.sitexxx.service.model.stat.UserRegisterStat;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.utils.PyUtils;
import org.tio.sitexxx.service.utils.QueryUtils;
import org.tio.utils.Threads;

public class StatService {
    private static Logger log = LoggerFactory.getLogger(StatService.class);
    public static final StatService me = new StatService();
    final TioIpPathAccessStat dao = (TioIpPathAccessStat)new TioIpPathAccessStat().dao();
    private static final int MAX_STAT_DAY = 60;

    public List<Record> requestCountByDay(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.requestCountByDay_" + days;
        return QueryUtils.findWithCache(CacheConfig.TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.requestCountByDay", true, days);
    }

    public List<Record> ipCountByDay(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.ipCountByDay_" + days;
        return QueryUtils.findWithCache(CacheConfig.TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.ipCountByDay", true, days);
    }

    public static void main(String[] args) {
    }

    public List<Record> statIpAndHitsByProvince(Integer days) {
        if (days == null) {
            days = 7;
        } else {
            if (days > 60) {
                days = 60;
            }
            if (days < 0) {
                days = 7;
            }
        }
        String cacheKey = "stat.statIpAndHitsByProvince_" + days;
        return QueryUtils.findWithCache(CacheConfig.TIME_TO_LIVE_MINUTE_5, cacheKey, "tio_site_stat", "stat.statIpAndHitsByProvince", true, days);
    }

    public Page<Record> ip(Boolean mergeRequest, String starttime, String endtime, Integer pageNumber, Integer pageSize) {
        Kv kv = Kv.by((Object)"starttime", (Object)starttime).set((Object)"endtime", (Object)endtime).set((Object)"mergeRequest", (Object)mergeRequest);
        Page page = Db.use((String)"tio_site_stat").template("stat.ip", (Map)kv).paginate(pageNumber.intValue(), pageSize.intValue());
        return page;
    }

    public void userRegisterStat(final User user) {
        final Integer threadid = me.threadInit(user.getIpid(), user.getId(), (byte)1);
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    UserRegisterStat ipTimeStat;
                    UserRegisterStat ipStat;
                    UserRegisterStat timeStat;
                    Date createtime = user.getCreatetime();
                    if (createtime == null) {
                        createtime = new Date();
                    }
                    String period = DateUtil.format((Date)createtime, (String)"yyyyMMdd");
                    IpInfo ipInfo = user.getIpInfo();
                    String ip = ipInfo.getIp();
                    if (StrUtil.isBlank((CharSequence)ip)) {
                        ip = "00000000";
                    }
                    if ((timeStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ?", new Object[]{(byte)1, period})) == null) {
                        timeStat = new UserRegisterStat();
                        timeStat.setStatbizstr(period);
                        timeStat.setType((byte)1);
                        timeStat.ignoreSave();
                    }
                    if ((ipStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ?", new Object[]{(byte)2, ip})) == null) {
                        ipStat = new UserRegisterStat();
                        ipStat.setStatbizstr(ip);
                        ipStat.setType((byte)2);
                        ipStat.setStatbizid(user.getIpid());
                        ipStat.ignoreSave();
                    }
                    if ((ipTimeStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ? and statbizid = ? ", new Object[]{(byte)3, period, user.getIpid()})) == null) {
                        ipTimeStat = new UserRegisterStat();
                        ipTimeStat.setStatbizstr(period);
                        ipTimeStat.setType((byte)3);
                        ipTimeStat.setStatbizid(user.getIpid());
                        ipTimeStat.ignoreSave();
                    }
                    Db.use((String)"tio_site_stat").update("update user_register_stat set regcount = regcount + 1 where (type = ? and statbizstr = ?) or (type = ? and statbizstr = ?) or (type = ? and statbizstr = ? and statbizid = ?) ", new Object[]{(byte)1, period, (byte)2, ip, (byte)3, period, user.getIpid()});
                    String city = ipInfo.getCity();
                    String province = ipInfo.getProvince();
                    if (StrUtil.isBlank((CharSequence)city) || StrUtil.isBlank((CharSequence)province)) {
                        return;
                    }
                    AreaStat stat = (AreaStat)AreaStat.dao.findFirst("select * from area_stat where city = ? and province = ? and type = ?", new Object[]{city, province, (byte)1});
                    if (stat == null) {
                        stat = new AreaStat();
                        stat.setCity(city);
                        stat.setProvince(province);
                        stat.setType((byte)1);
                        stat.setBizcount(1);
                        stat.setCharindex(PyUtils.getAllChat((String)province));
                        stat.setCitychatindex(PyUtils.getAllChat((String)city));
                        stat.ignoreSave();
                    } else {
                        Db.use((String)"tio_site_stat").update("update area_stat set bizcount = bizcount + 1 where city = ? and province = ? and type = ?", new Object[]{city, province, (byte)1});
                    }
                    me.threadDeal(threadid);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }

    public void userRegisterStatInit() {
        Db.use((String)"tio_site_stat").update("truncate table user_register_stat");
        Db.use((String)"tio_site_stat").update("truncate table area_stat");
        List users = User.dao.find("select * from `user` order by id");
        long start = System.currentTimeMillis();
        log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u5f00\u59cb\u4eba\u5458\u6ce8\u518c\u7edf\u8ba1\u521d\u59cb\u5316\uff1a" + users.size());
        for (User user1 : users) {
            UserRegisterStat ipTimeStat;
            UserRegisterStat ipStat;
            Date createtime = user1.getCreatetime();
            if (createtime == null) {
                log.error("\u7528\u6237\u7684\u521b\u5efa\u65f6\u95f4\u4e3a\u7a7a");
                continue;
            }
            String period = DateUtil.format((Date)createtime, (String)"yyyyMMdd");
            String ip = "";
            IpInfo ipInfo = IpInfoService.ME.getById(user1.getIpid());
            ip = ipInfo == null || StrUtil.isBlank((CharSequence)ipInfo.getIp()) ? "00000000" : ipInfo.getIp();
            UserRegisterStat timeStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ?", new Object[]{(byte)1, period});
            if (timeStat == null) {
                timeStat = new UserRegisterStat();
                timeStat.setStatbizstr(period);
                timeStat.setType((byte)1);
                timeStat.save();
            }
            if ((ipStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ?", new Object[]{(byte)2, ip})) == null) {
                ipStat = new UserRegisterStat();
                ipStat.setStatbizstr(ip);
                ipStat.setType((byte)2);
                ipStat.setStatbizid(user1.getIpid());
                ipStat.save();
            }
            if ((ipTimeStat = (UserRegisterStat)UserRegisterStat.dao.findFirst("SELECT * from user_register_stat where type = ? and statbizstr = ? and statbizid = ? ", new Object[]{(byte)3, period, user1.getIpid()})) == null) {
                ipTimeStat = new UserRegisterStat();
                ipTimeStat.setStatbizstr(period);
                ipTimeStat.setType((byte)3);
                ipTimeStat.setStatbizid(user1.getIpid());
                ipTimeStat.ignoreSave();
            }
            Db.use((String)"tio_site_stat").update("update user_register_stat set regcount = regcount + 1 where (type = ? and statbizstr = ?) or (type = ? and statbizstr = ?) or (type = ? and statbizstr = ? and statbizid = ?) ", new Object[]{(byte)1, period, (byte)2, ip, (byte)3, period, user1.getIpid()});
            String city = ipInfo.getCity();
            String province = ipInfo.getProvince();
            if (StrUtil.isBlank((CharSequence)city) || StrUtil.isBlank((CharSequence)province)) continue;
            AreaStat stat = (AreaStat)AreaStat.dao.findFirst("select * from area_stat where city = ? and province = ? and type = ?", new Object[]{city, province, (byte)1});
            if (stat == null) {
                stat = new AreaStat();
                stat.setCity(city);
                stat.setProvince(province);
                stat.setType((byte)1);
                stat.setBizcount(1);
                stat.setCharindex(PyUtils.getAllChat((String)province));
                stat.setCitychatindex(PyUtils.getAllChat((String)city));
                stat.ignoreSave();
                continue;
            }
            Db.use((String)"tio_site_stat").update("update area_stat set bizcount = bizcount + 1 where city = ? and province = ? and type = ?", new Object[]{city, province, (byte)1});
        }
        long end = System.currentTimeMillis();
        long exe = (end - start) / 60000L;
        log.error(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\u7ed3\u675f\u4eba\u5458\u6ce8\u518c\u7edf\u8ba1\u521d\u59cb\u5316\uff0c\u603b\u65f6\u95f4\uff1a{}", (Object)exe);
    }

    public void fdKeyInit() {
        Db.use((String)"tio_site_main").update("truncate table wx_friend_meta");
        Db.use((String)"tio_site_main").update("insert into wx_friend_meta(uid,touid,fidkey) select max(uid),min(touid),twouid from wx_friend_msg group by twouid ");
        Db.use((String)"tio_site_main").update("insert IGNORE into wx_friend_meta(uid,touid,fidkey) select max(uid),min(touid),twouid from wx_friend_msg_bak group by twouid ");
        List friends = WxFriend.dao.findAll();
        HashMap existMap = new HashMap();
        for (WxFriend friend : friends) {
            String fdkey = UserService.twoUid(friend.getUid(), friend.getFrienduid());
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)existMap.get(fdkey)))) continue;
            WxFriendMeta meta = new WxFriendMeta();
            meta.setUid(friend.getUid());
            meta.setTouid(friend.getFrienduid());
            meta.setFidkey(fdkey);
            meta.ignoreSave();
        }
        Db.use((String)"tio_site_main").update("update wx_friend_meta outtable set msgcount = (select count(1) from wx_friend_msg_bak intable where intable.twouid = outtable.fidkey),lastmsgid = (select max(intable.id) from wx_friend_msg_bak intable where intable.twouid = outtable.fidkey)");
        Db.use((String)"tio_site_main").update("update wx_friend_meta outtable set msgcount = msgcount + (select count(1) from wx_friend_msg intable where intable.twouid = outtable.fidkey),lastmsgid = (select max(intable.id) from wx_friend_msg intable where intable.twouid = outtable.fidkey)");
    }

    public Integer threadInit(Integer bizint, String bizstr, Byte type) {
        if (bizint == null && StrUtil.isBlank((CharSequence)bizstr)) {
            log.error("\u7ebf\u7a0b\u6267\u884c\u7edf\u8ba1\u65f6\uff0c\u4e3b\u952e\u4fe1\u606f\u90fd\u4e3a\u7a7a\uff0ctype:{}", (Object)type);
            return null;
        }
        TioThreadLogs threadLogs = new TioThreadLogs();
        threadLogs.setBizint(bizint);
        threadLogs.setBizstr(bizstr);
        threadLogs.setStatus((byte)2);
        threadLogs.setType(type);
        threadLogs.save();
        return threadLogs.getId();
    }

    public void threadDeal(Integer id) {
        if (id == null) {
            log.error("\u91cd\u8981\u63d0\u9192------------------------------>\u7ebf\u7a0b\u6267\u884c\u7edf\u8ba1\u65f6\uff0c\u65e5\u5fd7id\u4e3a\u7a7a");
            return;
        }
        TioThreadLogs threadLogs = new TioThreadLogs();
        threadLogs.setId(id);
        threadLogs.setStatus((byte)1);
        boolean update = threadLogs.update();
        if (!update) {
            log.error("\u91cd\u8981\u63d0\u9192------------------------------>\u7ebf\u7a0b\u6267\u884c\u7edf\u8ba1\u65f6\uff0c\u4fee\u6539\u5931\u8d25\uff0cid:{}", (Object)id);
        }
    }
}

