/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.wx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.UserThird;
import org.tio.sitexxx.service.model.main.UserThirdOsc;
import org.tio.sitexxx.service.model.main.WxChatUserItem;
import org.tio.sitexxx.service.model.main.WxFriend;
import org.tio.sitexxx.service.model.main.WxFriendApplyLog;
import org.tio.sitexxx.service.model.main.WxFriendDelLog;
import org.tio.sitexxx.service.model.main.WxFriendMsg;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.atom.AbsAtom;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.base.UserService;
import org.tio.sitexxx.service.service.base.UserThirdOscService;
import org.tio.sitexxx.service.service.base.UserThirdService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.service.chat.ChatService;
import org.tio.sitexxx.service.service.chat.FriendService;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.utils.LockUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.WriteLockHandler;
import org.tio.utils.resp.Resp;

public class WxFriendService {
    private static Logger log = LoggerFactory.getLogger(WxFriendService.class);
    public static final WxFriendService me = new WxFriendService();
    static final ICache WX_FRIEND_MSG_CACHE = Caches.getCache(CacheConfig.WX_FRIEND_MSG);
    static final int WX_FRIEND_MSG_LIMIT = 100;
    static final ICache RECENT_MSG_NOT_READ_CACHE = Caches.getCache(CacheConfig.WX_RECENT_MSG_NOT_READ);
    static final ICache RECENT_MSG_CACHE = Caches.getCache(CacheConfig.WX_RECENT_MSG);
    static final int RECENT_MSG_LIMIT = 36;

    public Resp delFriend(final User curr, final String frienduid, final Integer ipid) throws Exception {
        final String curruid = curr.getId();
        AbsAtom atom = new AbsAtom(){

            public boolean run() throws SQLException {
                int c = Db.use((String)"tio_site_main").update("delete from wx_friend where uid=? and frienduid=?", new Object[]{curruid, frienduid});
                if (c > 0) {
                    WxFriendDelLog wxFriendDelLog = new WxFriendDelLog();
                    wxFriendDelLog.setIpid(ipid);
                    wxFriendDelLog.setFrienduid(frienduid);
                    wxFriendDelLog.setUid(curruid);
                    boolean ret = wxFriendDelLog.save();
                    WxFriendService.clearFriendCache(curr, frienduid);
                    return true;
                }
                return false;
            }
        };
        boolean ret = atom.run();
        if (ret) {
            ChatIndexService.clearChatP2pIndex(curruid, frienduid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5bf9\u65b9\u53ef\u80fd\u5e76\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
    }

    public Resp modifyRemarkname(User curr, String frienduid, String remarkname) {
        String sql = "update wx_friend set remarkname = ?  where uid = ? and frienduid = ?";
        Db.use((String)"tio_site_main").update(sql, new Object[]{remarkname, curr.getId(), frienduid});
        WxFriendService.clearFriendCache(curr, frienduid);
        return Resp.ok();
    }

    public WxFriend getWxFriend(User curr, String frienduid) {
        WxChatUserItem userItem = ChatIndexService.fdUserIndex(curr.getId(), frienduid);
        if (!ChatService.existFriend(userItem)) {
            return null;
        }
        return FriendService.me.getFriendInfo(userItem.getLinkid());
    }

    public List<Record> queryChatList(String uid1, String uid2, Long startMid) {
        if (uid1 == null || uid2 == null) {
            return null;
        }
        String twouid = UserService.twoUid(uid1, uid2);
        Kv kv = Kv.by((Object)"twouid", (Object)twouid).set((Object)"startMid", (Object)startMid);
        return Db.template((String)"wxfriend.queryChatList", (Map)kv).find();
    }

    public boolean applyFriend(WxFriendApplyLog wxFriendApplyLog) throws Exception {
        boolean ret = Db.tx(() -> {
            String sql = "update wx_friend_apply_log set status = 5 where status in (3, 4) and fromuid = ? and touid = ?";
            Db.use((String)"tio_site_main").update(sql, new Object[]{wxFriendApplyLog.getFromuid(), wxFriendApplyLog.getTouid()});
            boolean f = wxFriendApplyLog.save();
            return f;
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resp replyApplyFriend(User curr, String frienduid, Integer result, String remarkname) throws Exception {
        Serializable lockObj;
        String twouid = "replyApplyFriend" + UserService.twoUid(curr.getId(), frienduid);
        Serializable serializable = lockObj = LockUtils.getLocalLockObj(twouid, (Object)this);
        synchronized (serializable) {
            Date date = new Date();
            Kv kv = Kv.by((Object)"replytime", (Object)date).set((Object)"fromuid", (Object)frienduid).set((Object)"status", (Object)result).set((Object)"touid", (Object)curr.getId());
            SqlPara sqlPara = WxFriendApplyLog.dao.getSqlPara("wxfriend.replyApplyFriend", (Map)kv);
            boolean f = Db.tx(() -> {
                int c = Db.use((String)"tio_site_main").update(sqlPara);
                if (c > 0) {
                    if (Objects.equals(result, 1)) {
                        boolean f1 = true;
                        String sql = "select 1 FROM wx_friend WHERE uid = ? AND frienduid = ? limit 0, 1";
                        Record record = Db.use((String)"tio_site_main").findFirst(sql, new Object[]{curr.getId(), frienduid});
                        if (record == null) {
                            WxFriend currFriend = new WxFriend();
                            currFriend.setCreatetime(date);
                            currFriend.setFrienduid(frienduid);
                            currFriend.setUid(curr.getId());
                            if (StrUtil.isNotBlank((CharSequence)remarkname)) {
                                currFriend.setRemarkname(remarkname);
                            }
                            f1 = currFriend.save();
                        }
                        if (f1) {
                            boolean f2 = true;
                            sql = "select 1 FROM wx_friend WHERE uid = ? AND frienduid = ? limit 0, 1";
                            record = Db.use((String)"tio_site_main").findFirst(sql, new Object[]{frienduid, curr.getId()});
                            if (record == null) {
                                WxFriend otherFriend = new WxFriend();
                                otherFriend.setCreatetime(date);
                                otherFriend.setUid(frienduid);
                                otherFriend.setFrienduid(curr.getId());
                                f2 = otherFriend.save();
                            }
                            if (f2) {
                                return true;
                            }
                        }
                    } else {
                        return true;
                    }
                }
                return false;
            });
            if (f) {
                WxFriendService.clearFriendCache(curr, frienduid);
                return Resp.ok();
            }
            return Resp.fail();
        }
    }

    @Deprecated
    public static void clearFriendCache(User curr, String frienduid) {
        ICache cache = Caches.getCache(CacheConfig.WX_MY_FRIEND);
        String cacheKey = curr.getId() + "_" + frienduid;
        cache.remove(cacheKey);
        ICache cache2 = Caches.getCache(CacheConfig.WX_IS_FRIEND);
        String cacheKey2 = UserService.twoUid(curr.getId(), frienduid);
        cache2.remove(cacheKey2);
    }

    public Resp addFriendDirectly(User curr, String frienduid, String remarkname) throws Exception {
        boolean f1;
        boolean inOtherFriendList = me.inMyFriendList(frienduid, curr.getId());
        if (!inOtherFriendList) {
            return Resp.fail((String)"\u60a8\u5df2\u7ecf\u4e0d\u5728\u5bf9\u65b9\u7684\u597d\u53cb\u5217\u8868\u4e2d\u5566\uff0c\u4e0d\u80fd\u76f4\u63a5\u52a0\u5bf9\u65b9\u4e3a\u597d\u53cb");
        }
        WxFriend wxFriend = new WxFriend();
        wxFriend.setCreatetime(new Date());
        wxFriend.setFrienduid(frienduid);
        wxFriend.setUid(curr.getId());
        if (StrUtil.isNotBlank((CharSequence)remarkname)) {
            wxFriend.setRemarkname(remarkname);
        }
        if (f1 = wxFriend.save()) {
            WxFriendService.clearFriendCache(curr, frienduid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public boolean isFriend(String uid, String frienduid) throws Exception {
        ICache cache = Caches.getCache(CacheConfig.WX_IS_FRIEND);
        String cacheKey = UserService.twoUid(uid, frienduid);
        return (Boolean)CacheUtils.get((ICache)cache, (String)cacheKey, (boolean)false, () -> {
            Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"frienduid", (Object)frienduid);
            Integer c = Db.use((String)"tio_site_main").template("wxfriend.isFriend", (Map)params).queryInt();
            if (Objects.equals(uid, frienduid)) {
                return c == 1;
            }
            return c == 2;
        });
    }

    public boolean inMyFriendList(String uid, String frienduid) throws Exception {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"frienduid", (Object)frienduid);
        Integer c = Db.use((String)"tio_site_main").template("wxfriend.inMyFriendList", (Map)params).queryInt();
        return c == 1;
    }

    public List<Record> queryLastApply(User curr) {
        String sql = "SELECT al.*, u.nick, u.avatar FROM wx_friend_apply_log al, user u where u.id = al.fromuid and al.touid = ? and al.status != 5 order by al.createtime desc limit 0, 200";
        List ret = Db.use((String)"tio_site_main").find(sql, new Object[]{curr.getId()});
        return ret;
    }

    public Page<Record> myFriends(User owner, Integer pageNumber, String nickOrRemarkname, Long groupid) throws Exception {
        if (owner == null) {
            return null;
        }
        int pageSize = 50;
        String owneruid = owner.getId();
        Kv params = Kv.by((Object)"uid", (Object)owneruid);
        if (StrUtil.isNotBlank((CharSequence)nickOrRemarkname)) {
            params.set((Object)"nick", (Object)("%" + nickOrRemarkname + "%"));
        }
        String sqlid = null;
        if (groupid != null) {
            params.set((Object)"groupid", (Object)groupid);
            sqlid = "wxfriend.myFriendsFilterGroup";
        } else {
            sqlid = "wxfriend.myFriends";
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara(sqlid, (Map)params);
        Page page = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize, sqlPara);
        return page;
    }

    public Page<Record> queryAddMeAsFriends(User currUser, String nickOrRemarkname, Integer pageNumber, Integer pageSize) throws Exception {
        if (currUser == null) {
            return null;
        }
        boolean isSuper = UserService.isSuper(currUser);
        String uid = currUser.getId();
        Kv params = Kv.by((Object)"uid", (Object)uid);
        if (StrUtil.isNotBlank((CharSequence)nickOrRemarkname)) {
            params.set((Object)"nick", (Object)("%" + nickOrRemarkname + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxfriend.queryAddMeAsFriends", (Map)params);
        Page page = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        this.perfectFriendInfo(isSuper, page.getList());
        return page;
    }

    public void perfectFriendInfo(boolean isSuper, List<Record> list) throws Exception {
        if (list != null) {
            for (Record record : list) {
                this.perfectFriendInfo(isSuper, record);
            }
        }
    }

    public void perfectFriendInfo(boolean isSuper, Record record) throws Exception {
        if (record == null) {
            return;
        }
        String uid = record.getStr("uid");
        if (uid != null) {
            User user = UserService.ME.getById(uid);
            record.set("roles", user.getRoles());
            if (user.getIpid() != null) {
                UserThird userThird;
                IpInfo ipInfo = IpInfoService.ME.getById(user.getIpid());
                if (ipInfo != null) {
                    record.set("ip", (Object)ipInfo.getIp());
                    record.set("country", (Object)ipInfo.getCountry());
                    record.set("province", (Object)ipInfo.getProvince());
                    record.set("city", (Object)ipInfo.getCity());
                }
                UserThirdOsc userThirdOsc = null;
                if ("5".equals(user.getPwd()) && user.getLoginname().startsWith("__osc_") && (userThird = UserThirdService.me.getByUid(uid)) != null && (userThirdOsc = UserThirdOscService.me.getByUserThirdId(userThird.getId())) != null) {
                    record.set("osc_url", (Object)userThirdOsc.getUrl());
                }
                if (isSuper) {
                    record.set("createtime", (Object)user.getCreatetime());
                    record.set("loginname", (Object)user.getLoginname());
                    if (userThirdOsc != null) {
                        record.set("osc_email", (Object)userThirdOsc.getEmail());
                    }
                }
            }
        }
    }

    public boolean save(WxFriendMsg wxFriendMsg) {
        boolean f;
        wxFriendMsg.setTwouid(UserService.twoUid(wxFriendMsg.getUid(), wxFriendMsg.getTouid()));
        if (Objects.equals(wxFriendMsg.getUid(), wxFriendMsg.getTouid())) {
            wxFriendMsg.setReadflag((byte)1);
        }
        if (f = wxFriendMsg.save()) {
            this.putToP2pCache(wxFriendMsg);
        }
        return f;
    }

    public WxFriendMsg saveChatRecord(Devicetype devicetype, String sessionid, String text, String fromuid, String fromIp, String touid, Byte contenttype, byte readflag, Byte sendbysys, Byte msgtype, String sigleuid) {
        IpInfo ipInfo = IpInfoService.ME.save(fromIp);
        WxFriendMsg wxFriendMsg = new WxFriendMsg();
        wxFriendMsg.setText(text);
        wxFriendMsg.setSigleuid(sigleuid);
        String resume = StrUtil.trim((CharSequence)HtmlUtil.cleanHtmlTag((String)text));
        resume = StrUtil.subWithLength((String)resume, (int)0, (int)20);
        wxFriendMsg.setResume(resume);
        wxFriendMsg.setMsgtype(msgtype);
        wxFriendMsg.setIpid(ipInfo.getId());
        wxFriendMsg.setDevice(devicetype.getValue());
        wxFriendMsg.setTime(new Date());
        wxFriendMsg.setTouid(touid);
        wxFriendMsg.setUid(fromuid);
        wxFriendMsg.setSession(sessionid);
        wxFriendMsg.setContenttype(contenttype);
        wxFriendMsg.setStatus((byte)1);
        wxFriendMsg.setReadflag(readflag);
        if (sendbysys != null) {
            wxFriendMsg.setSendbysys(sendbysys);
        }
        this.save(wxFriendMsg);
        return wxFriendMsg;
    }

    public WxFriendMsg saveChatRecord(Devicetype devicetype, String sessionid, String text, String fromuid, String fromIp, String touid, Byte contenttype, byte readflag, Byte sendbysys) {
        return this.saveChatRecord(devicetype, sessionid, text, fromuid, fromIp, touid, contenttype, readflag, sendbysys, (byte)1, null);
    }

    public void updateStatus(Long mid, byte status, WxFriendMsg wxFriendMsg) {
        String sql = "update wx_friend_msg set status = ? where id = ?";
        int f = Db.use((String)"tio_site_main").update(sql, new Object[]{status, mid});
        if (f > 0) {
            this.clearP2pChatCache(wxFriendMsg.getUid(), wxFriendMsg.getTouid());
        }
    }

    public int updateToRead(String fromuid, String touid, Byte readdevice, Integer readipid, Date readtime) {
        String sql = "update wx_friend_msg set readflag = 1, readtime = ?, readdevice=?, readipid = ? where uid = ? and touid = ? and readflag = 2";
        int f = Db.use((String)"tio_site_main").update(sql, new Object[]{readtime, readdevice, readipid, fromuid, touid});
        if (f > 0) {
            this.clearP2pChatCache(fromuid, touid);
        }
        return f;
    }

    public void clearP2pChatCache(String fromuid, String touid) {
        String key = UserService.twoUid(fromuid, touid);
        WX_FRIEND_MSG_CACHE.remove(key);
        String key2 = "" + touid;
        RECENT_MSG_NOT_READ_CACHE.remove(key2);
        String key3 = key2;
        RECENT_MSG_CACHE.remove(key3);
        RECENT_MSG_CACHE.remove("" + fromuid);
    }

    public WxFriendMsg getByMid(String mid) {
        String sql = "select * from wx_friend_msg where id = ?";
        return (WxFriendMsg)WxFriendMsg.dao.findFirst(sql, new Object[]{Integer.parseInt(mid)});
    }

    public List<Record> getRecentMsgNotRead(final User curr) {
        if (curr == null) {
            return null;
        }
        final String curruid = curr.getId();
        String key = "" + curruid;
        List list = (List)((Object)CacheUtils.get((ICache)RECENT_MSG_NOT_READ_CACHE, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ArrayList<Record>>(){

            public ArrayList<Record> create() {
                Kv params = Kv.by((Object)"touid", (Object)curruid);
                params.set((Object)"limit", (Object)36);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxfriend.recent_msg_not_read", (Map)params);
                List list = Db.use((String)"tio_site_main").find(sqlPara);
                WxFriendService.this.completeRecent(list, curr);
                return (ArrayList)list;
            }
        }));
        return list;
    }

    public List<Record> getRecentMsgHasRead(List<Record> notReadList, User curr) {
        if (curr == null) {
            return null;
        }
        String curruid = curr.getId();
        Kv params = Kv.by((Object)"touid", (Object)curruid);
        int limit = 36;
        if (notReadList != null && notReadList.size() > 0) {
            limit -= notReadList.size();
            StringBuilder notInUidStr = new StringBuilder();
            for (Record record : notReadList) {
                Integer uid = record.getInt("uid");
                if (!Objects.equals(uid, curruid)) {
                    notInUidStr.append(uid).append(",");
                    continue;
                }
                notInUidStr.append(record.getStr("touid")).append(",");
            }
            notInUidStr.setLength(notInUidStr.length() - 1);
            params.put((Object)"notInUidStr", (Object)notInUidStr);
        }
        limit = Math.max(limit, 50);
        params.put((Object)"limit", (Object)limit);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxfriend.recent_msg_has_read", (Map)params);
        List list2 = Db.use((String)"tio_site_main").find(sqlPara);
        this.completeRecent(list2, curr);
        return list2;
    }

    public List<Record> getRecentMsg(final User curr) {
        if (curr == null) {
            return null;
        }
        String curruid = curr.getId();
        String key = "" + curruid;
        List list = (List)((Object)CacheUtils.get((ICache)RECENT_MSG_CACHE, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ArrayList<Record>>(){

            public ArrayList<Record> create() {
                List<Record> notReadList = WxFriendService.this.getRecentMsgNotRead(curr);
                List<Record> hasReadList = WxFriendService.this.getRecentMsgHasRead(notReadList, curr);
                if (CollUtil.isNotEmpty(notReadList)) {
                    notReadList.addAll(hasReadList);
                    return (ArrayList)notReadList;
                }
                return (ArrayList)hasReadList;
            }
        }));
        return list;
    }

    private void completeRecent(List<Record> list, User curr) {
        if (list != null && list.size() > 0) {
            for (Record record : list) {
                this.completeRecent(record, curr);
            }
        }
    }

    private void completeRecent(Record record, User curr) {
        User user;
        String touid;
        String curruid = curr.getId();
        String uid = record.getStr("uid");
        if (!Objects.equals(uid, touid = record.getStr("touid")) && Objects.equals(curruid, uid)) {
            uid = touid;
            record.set("uid", (Object)touid);
        }
        if ((user = UserService.ME.getById(uid)) != null) {
            WxFriend wxFriend;
            record.set("nick", (Object)user.getNick());
            record.set("avatar", (Object)user.getAvatar());
            record.set("roles", user.getRoles());
            if (!Objects.equals(curruid, uid) && (wxFriend = this.getWxFriend(curr, uid)) != null) {
                record.set("remarkname", (Object)wxFriend.getRemarkname());
            }
        }
    }

    public ListWithLock<WxFriendMsg> getLastP2pChat(final String uid1, final String uid2) {
        if (uid1 == null || uid2 == null) {
            return null;
        }
        String key = UserService.twoUid(uid1, uid2);
        ListWithLock listWithLock = (ListWithLock)CacheUtils.get((ICache)WX_FRIEND_MSG_CACHE, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ListWithLock<WxFriendMsg>>(){

            public ListWithLock<WxFriendMsg> create() {
                int historyCount = ConfService.getInt("im.history.chat.count.p2p", 100);
                String sql = "select text, contenttype, id, time, touid, uid, readflag, sendbysys, readtime from wx_friend_msg where ((touid = ? and uid = ?) or (touid = ? and uid = ?)) and contenttype != 7 and status = 1 order by id desc limit ?";
                ArrayList list = (ArrayList)WxFriendMsg.dao.find(sql, new Object[]{uid1, uid2, uid2, uid1, historyCount});
                return new ListWithLock((List)list);
            }
        });
        return listWithLock;
    }

    public void putToP2pCache(final WxFriendMsg chatRecord) {
        if (7 == chatRecord.getContenttype()) {
            return;
        }
        String uid = chatRecord.getUid();
        String touid = chatRecord.getTouid();
        String key = chatRecord.getTwouid();
        if (key != null) {
            ListWithLock listWithLock = (ListWithLock)WX_FRIEND_MSG_CACHE.get(key, ListWithLock.class);
            if (listWithLock != null) {
                listWithLock.handle((WriteLockHandler)new WriteLockHandler<List<WxFriendMsg>>(){

                    public void handler(List<WxFriendMsg> list) {
                        list.add(0, chatRecord);
                        int historyCount = ConfService.getInt("im.history.chat.count.p2p", 100);
                        while (list.size() > historyCount) {
                            list.remove(historyCount);
                        }
                    }
                });
            }
            String key2 = "" + touid;
            RECENT_MSG_NOT_READ_CACHE.remove(key2);
            String key3 = key2;
            RECENT_MSG_CACHE.remove(key3);
            RECENT_MSG_CACHE.remove("" + uid);
        }
    }
}

