/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.service.wx;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.sitexxx.service.model.main.IpInfo;
import org.tio.sitexxx.service.model.main.WxGroup;
import org.tio.sitexxx.service.model.main.WxGroupMsg;
import org.tio.sitexxx.service.model.main.WxGroupUser;
import org.tio.sitexxx.service.model.main.WxGroupUserDelLog;
import org.tio.sitexxx.service.model.main.WxGroupUserInviteLog;
import org.tio.sitexxx.service.model.system.User;
import org.tio.sitexxx.service.service.atom.AbsAtom;
import org.tio.sitexxx.service.service.base.IpInfoService;
import org.tio.sitexxx.service.service.chat.ChatIndexService;
import org.tio.sitexxx.service.utils.CommonUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.utils.resp.Resp;

public class WxGroupService {
    private static Logger log = LoggerFactory.getLogger(WxGroupService.class);
    public static final WxGroupService me = new WxGroupService();

    public Resp modifyIntro(User curr, Long groupid, String intro) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u7b80\u4ecb");
        }
        if (StrUtil.isBlank((CharSequence)intro)) {
            wxGroup.setIntro("");
        } else {
            wxGroup.setIntro(intro);
        }
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp modifyJoinMode(User curr, Long groupid, Byte mode) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u52a0\u5165\u65b9\u5f0f");
        }
        wxGroup.setJoinmode(mode);
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp modifyGroupAvatar(Long groupid, String avatar) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        wxGroup.setAvatar(avatar);
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp modifyName(User curr, Long groupid, String name) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u540d\u5b57");
        }
        wxGroup.setName(name);
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp modifyNotice(User curr, Long groupid, String notice) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u516c\u544a");
        }
        if (StrUtil.isBlank((CharSequence)notice)) {
            wxGroup.setNotice("");
            wxGroup.setNoticetime(null);
        } else {
            wxGroup.setNotice(notice);
            wxGroup.setNoticetime(new Date());
        }
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public WxGroup getByGroupid(Long groupid) {
        WxGroup wxGroup = (WxGroup)WxGroup.dao.findById(groupid);
        return wxGroup;
    }

    public Resp leave(User curr, Long groupid) {
        String uid = curr.getId();
        Record record = this.info(groupid);
        if (record == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        boolean f = Db.tx(() -> {
            String sql = "delete from wx_group_user where groupid = ? and uid = ?";
            int c = Db.use((String)"tio_site_main").update(sql, new Object[]{groupid, curr.getId()});
            if (c > 0) {
                Date date = new Date();
                WxGroupUserDelLog wxGroupUserDelLog = new WxGroupUserDelLog();
                wxGroupUserDelLog.setUid(uid);
                wxGroupUserDelLog.setDeleteduid(curr.getId());
                wxGroupUserDelLog.setCreatetime(date);
                wxGroupUserDelLog.setUpdatetime(date);
                wxGroupUserDelLog.setGroupid(groupid);
                wxGroupUserDelLog.save();
                this.updateInviteLogStatus(groupid, null, curr.getId());
                return true;
            }
            return false;
        });
        if (f) {
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp del(User curr, Long groupid) {
        String uid = curr.getId();
        Record record = this.info(groupid);
        if (record == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(uid, record.getInt("uid"))) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u5220\u9664\u7fa4");
        }
        boolean f = Db.tx(() -> {
            String sql = "update wx_group_user set status = 2 where groupid = ?";
            int c = Db.use((String)"tio_site_main").update(sql, new Object[]{groupid});
            sql = "update wx_group set status = 3 where id = ?";
            c = Db.use((String)"tio_site_main").update(sql, new Object[]{groupid});
            this.updateInviteLogStatus(groupid, null, null);
            return c > 0;
        });
        if (f) {
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public Resp delMember(User curr, Long groupid, String[] uids) {
        if (uids == null || uids.length == 0) {
            return Resp.fail((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        String uid = curr.getId();
        Record record = this.info(groupid);
        if (record == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(uid, record.getInt("uid"))) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u5220\u9664\u7528\u6237");
        }
        Date date = new Date();
        ArrayList<WxGroupUserDelLog> list = new ArrayList<WxGroupUserDelLog>();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (String deleteduid : uids) {
            WxGroupUserDelLog wxGroupUserDelLog = new WxGroupUserDelLog();
            wxGroupUserDelLog.setUid(uid);
            wxGroupUserDelLog.setDeleteduid(deleteduid);
            wxGroupUserDelLog.setCreatetime(date);
            wxGroupUserDelLog.setUpdatetime(date);
            wxGroupUserDelLog.setGroupid(groupid);
            list.add(wxGroupUserDelLog);
            sb.append(deleteduid).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        String instr = sb.toString();
        boolean f = Db.tx(() -> {
            Db.use((String)"tio_site_main").batchSave(list, 500);
            String sql = "delete from wx_group_user where groupid = ? and uid in " + instr;
            int c = Db.use((String)"tio_site_main").update(sql, new Object[]{groupid});
            this.updateInviteLogStatus(groupid, instr, null);
            return true;
        });
        if (f) {
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private void updateInviteLogStatus(long groupid, String inviteduidStr, String uid) {
        String sql = null;
        sql = uid == null && StrUtil.isBlank((CharSequence)inviteduidStr) ? "update wx_group_user_invite_log set status = 2 where groupid = ? and status = 1" : (uid == null ? "update wx_group_user_invite_log set status = 2 where groupid = ? and inviteduid in " + inviteduidStr + " and status = 1" : "update wx_group_user_invite_log set status = 2 where groupid = ? and inviteduid = " + uid + " and status = 1");
        Db.use((String)"tio_site_main").update(sql, new Object[]{groupid});
    }

    public WxGroupUser getWxGroupUser(String uid, long groupid) {
        String sql = "select * from wx_group_user where groupid = ? and uid = ?";
        WxGroupUser wxGroupUser = (WxGroupUser)WxGroupUser.dao.findFirst(sql, new Object[]{groupid, uid});
        return wxGroupUser;
    }

    public Resp directInvite(User curr, Long groupid, String[] uids) {
        if (uids == null || uids.length == 0) {
            return Resp.fail((String)"\u8bf7\u9009\u62e9\u8981\u9080\u8bf7\u7684\u7528\u6237");
        }
        String uid = curr.getId();
        Record record = this.info(groupid);
        if (record == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (Objects.equals(record.getByte("joinmode"), (byte)1) && !Objects.equals(uid, record.getInt("uid"))) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u9080\u8bf7\u7528\u6237\u5165\u7fa4");
        }
        Date date = new Date();
        ArrayList<WxGroupUserInviteLog> list = new ArrayList<WxGroupUserInviteLog>();
        for (String inviteduid : uids) {
            WxGroupUserInviteLog wxGroupUserInviteLog = new WxGroupUserInviteLog();
            wxGroupUserInviteLog.setUid(uid);
            wxGroupUserInviteLog.setInviteduid(inviteduid);
            wxGroupUserInviteLog.setCreatetime(date);
            wxGroupUserInviteLog.setUpdatetime(date);
            wxGroupUserInviteLog.setGroupid(groupid);
            list.add(wxGroupUserInviteLog);
        }
        String sql = "select max(id) as id from wx_group_msg where groupid = ?";
        Long maxmsgid = Db.use((String)"tio_site_main").queryLong(sql, new Object[]{groupid});
        if (maxmsgid == null) {
            maxmsgid = 0L;
        }
        Db.use((String)"tio_site_main").batchSave(list, 500);
        int count = 0;
        for (String inviteduid : uids) {
            WxGroupUser wxGroupUser = this.getWxGroupUser(inviteduid, groupid);
            if (wxGroupUser != null && Objects.equals(wxGroupUser.getStatus(), (byte)1)) continue;
            ++count;
            if (wxGroupUser == null) {
                wxGroupUser = new WxGroupUser();
                wxGroupUser.setGroupid(groupid);
                wxGroupUser.setLastmsgid(maxmsgid);
                wxGroupUser.setStartmsgid(maxmsgid);
                wxGroupUser.setUid(inviteduid);
                wxGroupUser.save();
                continue;
            }
            wxGroupUser.setLastmsgid(maxmsgid);
            wxGroupUser.setStartmsgid(maxmsgid);
            wxGroupUser.setStatus((byte)1);
            wxGroupUser.update();
        }
        return Resp.ok().data((Object)count);
    }

    public Resp agreeInvite(User curr, Long groupid) {
        int iv = 2;
        DateTime date = DateUtil.offset((Date)new Date(), (DateField)DateField.DAY_OF_YEAR, (int)(-iv));
        String sql = "select * from wx_group_user_invite_log where groupid = ? and inviteduid = ? and createtime > ? and status = 1";
        WxGroupUserInviteLog wxGroupUserInviteLog = (WxGroupUserInviteLog)WxGroupUserInviteLog.dao.findFirst(sql, new Object[]{groupid, curr.getId(), date});
        if (wxGroupUserInviteLog == null) {
            return Resp.fail((String)"\u5e76\u6ca1\u6709\u4eba\u9080\u8bf7\u4f60\u8fdb\u8fd9\u4e2a\u7fa4\uff0c\u6216\u9080\u8bf7\u5df2\u7ecf\u8fc7\u671f\uff0c\u6216\u60a8\u4e2d\u9014\u9000\u51fa\u8fc7\u8be5\u7fa4");
        }
        WxGroupUser wxGroupUser = this.getWxGroupUser(curr.getId(), groupid);
        if (wxGroupUser != null && Objects.equals(wxGroupUser.getStatus(), (byte)1)) {
            return Resp.fail((String)"\u60a8\u5df2\u7ecf\u5728\u7fa4\u91cc\u5566");
        }
        sql = "select max(id) as id from wx_group_msg where groupid = ?";
        Long maxmsgid = Db.use((String)"tio_site_main").queryLong(sql, new Object[]{groupid});
        if (maxmsgid == null) {
            maxmsgid = 0L;
        }
        if (wxGroupUser == null) {
            wxGroupUser = new WxGroupUser();
            wxGroupUser.setGroupid(groupid);
            wxGroupUser.setLastmsgid(maxmsgid);
            wxGroupUser.setStartmsgid(maxmsgid);
            wxGroupUser.setUid(curr.getId());
            wxGroupUser.save();
        } else {
            wxGroupUser.setLastmsgid(maxmsgid);
            wxGroupUser.setStartmsgid(maxmsgid);
            wxGroupUser.setStatus((byte)1);
            wxGroupUser.update();
        }
        return Resp.ok();
    }

    public Resp invite(User curr, Long groupid, String[] uids) {
        if (uids == null || uids.length == 0) {
            return Resp.fail((String)"\u8bf7\u9009\u62e9\u8981\u9080\u8bf7\u7684\u7528\u6237");
        }
        String uid = curr.getId();
        Record record = this.info(groupid);
        if (record == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (Objects.equals(record.getByte("joinmode"), (byte)1) && !Objects.equals(uid, record.getInt("uid"))) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u9080\u8bf7\u7528\u6237\u5165\u7fa4");
        }
        Date date = new Date();
        ArrayList<WxGroupUserInviteLog> list = new ArrayList<WxGroupUserInviteLog>();
        for (String inviteduid : uids) {
            WxGroupUserInviteLog wxGroupUserInviteLog = new WxGroupUserInviteLog();
            wxGroupUserInviteLog.setUid(uid);
            wxGroupUserInviteLog.setInviteduid(inviteduid);
            wxGroupUserInviteLog.setCreatetime(date);
            wxGroupUserInviteLog.setUpdatetime(date);
            wxGroupUserInviteLog.setGroupid(groupid);
            list.add(wxGroupUserInviteLog);
        }
        Db.use((String)"tio_site_main").batchSave(list, 500);
        return Resp.ok();
    }

    public Resp changeOwner(String uid, String otherUid, Long groupid) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return Resp.fail((String)"\u672c\u7fa4\u5df2\u89e3\u6563");
        }
        if (!Objects.equals(wxGroup.getUid(), uid)) {
            return Resp.fail((String)"\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u8f6c\u79fb\u6743\u9650");
        }
        wxGroup.setUid(otherUid);
        boolean f = wxGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Resp.ok();
        }
        return Resp.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    public int updateToRead(Long groupid, String uid, Long lastmsgid) {
        Kv kv = Kv.by((Object)"uid", (Object)uid).set((Object)"groupid", (Object)groupid).set((Object)"lastmsgid", (Object)lastmsgid);
        return Db.template((String)"wxgroup.updateToRead", (Map)kv).update();
    }

    public List<Record> queryChatList(Long groupid, String uid, Long startMid) {
        Kv kv = Kv.by((Object)"uid", (Object)uid).set((Object)"startMid", (Object)startMid).set((Object)"groupid", (Object)groupid);
        return Db.template((String)"wxgroup.queryChatList", (Map)kv).find();
    }

    public List<Long> myGroups(Integer uid) {
        String sql = "SELECT groupid FROM wx_group_user where uid = ?";
        List list = Db.use((String)"tio_site_main").query(sql, new Object[]{uid});
        return list;
    }

    public Page<Record> member(Long groupid, String nick, Integer pageNumber) {
        if (groupid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid);
        Integer pageSize = 50;
        if (StrUtil.isNotBlank((CharSequence)nick)) {
            nick = "%" + nick + "%";
            params.set((Object)"nick", (Object)nick);
        }
        if (pageNumber == null || pageNumber < 1) {
            pageNumber = 1;
        }
        SqlPara sqlPara = User.dao.getSqlPara("wxgroup.member", (Map)params);
        Page page = Db.paginate((int)pageNumber, (int)pageSize, (SqlPara)sqlPara);
        return page;
    }

    public List<Record> groupUserOrder(Long groupid, Integer limit) {
        if (groupid == null) {
            return null;
        }
        if (limit == null || limit <= 0) {
            limit = 10;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"limit", (Object)limit);
        SqlPara sqlPara = User.dao.getSqlPara("wxgroup.groupUserOrderBy", (Map)params);
        List list = Db.use((String)"tio_site_main").find(sqlPara);
        return list;
    }

    public int count(Long groupid) {
        if (groupid == null) {
            return 0;
        }
        return Db.use((String)"tio_site_main").queryInt("SELECT count(*) count FROM wx_group_user WHERE groupid = ? and status = 1", new Object[]{groupid});
    }

    public Record info(Long groupid) {
        if (groupid == null) {
            return null;
        }
        Kv kv = Kv.by((Object)"groupid", (Object)groupid);
        return Db.template((String)"wxgroup.info", (Map)kv).findFirst();
    }

    public Resp createGroup(final User curr, final WxGroup wxGroup, final String uidList) throws Exception {
        String name = wxGroup.getName();
        Resp resp = CommonUtils.checkGroupName(name, "\u7fa4\u540d");
        if (!resp.isOk()) {
            return resp;
        }
        String avatar = wxGroup.getAvatar();
        if (StrUtil.isBlank((CharSequence)avatar)) {
            wxGroup.setAvatar("/img/group.png");
        }
        wxGroup.setUid(curr.getId());
        wxGroup.setStatus((byte)1);
        Date date = new Date();
        wxGroup.setCreatetime(date);
        wxGroup.setUpdatetime(date);
        AbsAtom atom = new AbsAtom(){

            public boolean run() throws SQLException {
                boolean f = wxGroup.save();
                if (f) {
                    WxGroupUser wxGroupUser = new WxGroupUser();
                    wxGroupUser.setGroupid(wxGroup.getId());
                    wxGroupUser.setLastmsgid(0L);
                    wxGroupUser.setUid(curr.getId());
                    boolean f2 = wxGroupUser.save();
                    if (f2) {
                        if (StrUtil.isNotBlank((CharSequence)uidList)) {
                            String[] uidArr;
                            for (String uidStr : uidArr = StrUtil.split((CharSequence)uidList, (CharSequence)",")) {
                                if (!StrUtil.isNotBlank((CharSequence)uidStr)) continue;
                                try {
                                    String uid = uidStr;
                                    if (StringUtils.equals((CharSequence)uid, (CharSequence)curr.getId())) continue;
                                    wxGroupUser = new WxGroupUser();
                                    wxGroupUser.setGroupid(wxGroup.getId());
                                    wxGroupUser.setLastmsgid(0L);
                                    wxGroupUser.setUid(uid);
                                    wxGroupUser.save();
                                }
                                catch (Exception e) {
                                    log.error("", (Throwable)e);
                                }
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        boolean f = atom.run();
        if (f) {
            return Resp.ok().data((Object)wxGroup);
        }
        return Resp.fail((String)"\u521b\u5efa\u5931\u8d25");
    }

    public List<Record> list(User user, String groupname) {
        Kv params = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"groupname", (Object)groupname);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxgroup.list", (Map)params);
        List ret = Db.use((String)"tio_site_main").find(sqlPara);
        return ret;
    }

    public List<Record> queryList(User user, String groupname) {
        Kv params = Kv.by((Object)"uid", (Object)user.getId());
        if (StrUtil.isNotBlank((CharSequence)groupname)) {
            params.set((Object)"groupname", (Object)groupname);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxgroup.querylist", (Map)params);
        List ret = Db.use((String)"tio_site_main").find(sqlPara);
        return ret;
    }

    public List<Record> getRecentMsg(String uid) {
        if (uid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        params.set((Object)"limit", (Object)50);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("wxgroup.recent_msg", (Map)params);
        List list = Db.use((String)"tio_site_main").find(sqlPara);
        if (!CollUtil.isEmpty((Collection)list)) {
            for (Record record : list) {
                Long groupid = record.getLong("groupid");
                Record wxGroup = me.info(groupid);
                if (wxGroup == null) continue;
                record.set("nick", wxGroup.get("name"));
                record.set("avatar", wxGroup.get("avatar"));
            }
        }
        return list;
    }

    public WxGroupMsg saveChatRecord(Devicetype devicetype, String sessionid, String text, String fromUid, String fromIp, long groupid, Byte contenttype, byte sendbysys) {
        IpInfo ipInfo = IpInfoService.ME.save(fromIp);
        WxGroupMsg wxGroupMsg = new WxGroupMsg();
        wxGroupMsg.setText(text);
        wxGroupMsg.setGroupid(groupid);
        wxGroupMsg.setIpid(ipInfo.getId());
        wxGroupMsg.setDevice(devicetype.getValue());
        wxGroupMsg.setTime(new Date());
        wxGroupMsg.setUid(fromUid);
        wxGroupMsg.setSession(sessionid);
        wxGroupMsg.setSendbysys(sendbysys);
        wxGroupMsg.setContenttype(contenttype);
        wxGroupMsg.setStatus((byte)1);
        boolean f = wxGroupMsg.save();
        if (f) {
            this.updateToRead(groupid, fromUid, wxGroupMsg.getId());
        }
        return wxGroupMsg;
    }

    public void updateStatus(Long mid, byte status) {
        String sql = "update wx_group_msg set status = ? where id = ?";
        Db.use((String)"tio_site_main").update(sql, new Object[]{status, mid});
    }
}

