/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.timetask;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.sitexxx.service.tool.MysqlTool;
import org.tio.utils.quartz.AbstractJobWithLog;

public class HistoryTableJob
extends AbstractJobWithLog {
    private static Logger log = LoggerFactory.getLogger(HistoryTableJob.class);
    private static final Map<String, Set<String>> map = new HashMap<String, Set<String>>();
    public static HistoryTableJob me;

    private static void addTable(String dbName, String tableName) {
        map.get(dbName).add(tableName);
    }

    public void run(JobExecutionContext context) throws Exception {
        Set<Map.Entry<String, Set<String>>> set = map.entrySet();
        for (Map.Entry<String, Set<String>> entry : set) {
            String dbName = entry.getKey();
            Set<String> tableNames = entry.getValue();
            for (String tableName : tableNames) {
                try {
                    String sql = "select count(*) from " + tableName;
                    Long c = Db.use((String)dbName).queryLong(sql);
                    if (c < 8000000L) continue;
                    MysqlTool.toHistory(dbName, tableName);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    static {
        map.put("tio_site_conf", new HashSet());
        map.put("tio_site_main", new HashSet());
        map.put("tio_site_stat", new HashSet());
        HistoryTableJob.addTable("tio_site_stat", "tio_token_path_access_stat");
        HistoryTableJob.addTable("tio_site_stat", "tio_ip_path_access_stat");
        HistoryTableJob.addTable("tio_site_stat", "tio_slow_request");
        HistoryTableJob.addTable("tio_site_stat", "tio_ip_stat");
        HistoryTableJob.addTable("tio_site_stat", "tio_channel_stat");
        me = new HistoryTableJob();
    }
}

