/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.topic;

import java.util.Map;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.init.RedisInit;
import org.tio.sitexxx.service.vo.ClearHttpCache;
import org.tio.utils.cache.CacheChangeType;
import org.tio.utils.cache.CacheChangedVo;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.json.Json;

public class Topics {
    private static Logger log = LoggerFactory.getLogger(Topics.class);

    public static void notifyRemoveHttpCache(String path, String uid, Map<String, Object> param, int clearType) {
        RedissonClient redisson = RedisInit.get();
        RTopic topic = redisson.getTopic("CLEAR_HTTP_CACHE");
        ClearHttpCache clearHttpCache = new ClearHttpCache();
        clearHttpCache.setPath(path);
        clearHttpCache.setParam(param);
        clearHttpCache.setUserid(uid);
        clearHttpCache.setClearType(clearType);
        topic.publish((Object)clearHttpCache);
        if (log.isInfoEnabled()) {
            log.info("\u53d1\u51fa\u901a\u77e5\uff0c\u51c6\u5907\u6e05\u9664/\u5220\u9664httpcache[{}], param:{}, uid:{}", new Object[]{path, Json.toJson(param), uid});
        }
    }

    public static void notifyRemoveLocalCache(String cacheName, String key) {
        CacheChangedVo cacheChangedVo = new CacheChangedVo(cacheName, key, CacheChangeType.REMOVE);
        CaffeineRedisCache.topic.publish((Object)cacheChangedVo);
    }

    public static void notifyClearLocalCache(String cacheName) {
        CacheChangedVo cacheChangedVo = new CacheChangedVo(cacheName, CacheChangeType.CLEAR);
        CaffeineRedisCache.topic.publish((Object)cacheChangedVo);
    }
}

