/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.utils;

import cn.hutool.core.date.DateUtil;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamOnlineUserNumRequest;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamOnlineUserNumResponse;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamRecordIndexFilesRequest;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamRecordIndexFilesResponse;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamSnapshotInfoRequest;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamSnapshotInfoResponse;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamsFrameRateAndBitRateDataRequest;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamsFrameRateAndBitRateDataResponse;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamsOnlineListRequest;
import com.aliyuncs.live.model.v20161101.DescribeLiveStreamsOnlineListResponse;
import com.aliyuncs.live.model.v20161101.ForbidLiveStreamRequest;
import com.aliyuncs.live.model.v20161101.ForbidLiveStreamResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.init.PropInit;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.SystemTimer;
import org.tio.utils.crypto.Md5;
import org.tio.utils.jfinal.P;
import org.tio.utils.json.Json;

public class AliLiveUtils {
    private static Logger log = LoggerFactory.getLogger(AliLiveUtils.class);
    private static IAcsClient client;

    public static String createPublishAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "");
    }

    public static String createPullRtmpAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "");
    }

    public static String createPullFlvAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, ".flv");
    }

    public static String createPullFlvUdAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "_lud.flv");
    }

    public static String createPullFlvHdAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "_lhd.flv");
    }

    public static String createPullFlvSdAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "_lsd.flv");
    }

    public static String createPullFlvLdAuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, "_lld.flv");
    }

    public static String createPullM3u8AuthKey(long currtime, long timeout, String streamname) {
        return AliLiveUtils.createAuthKey(currtime, timeout, streamname, ".m3u8");
    }

    public static String createAuthKey(long currtime, long timeout, String streamname, String suffix) {
        String appname = Const.AliLive.APPNAME;
        long time = new Date(currtime / 1000L + timeout).getTime();
        String authkey1 = P.get((String)"ali.live.authkey.1", (String)Const.AliLive.AUTHKEY1);
        String initStr = "/" + appname + "/" + streamname + suffix + "-" + time + "-0-0-" + authkey1;
        String ret = time + "-0-0-" + Md5.getMD5((String)initStr);
        return ret;
    }

    public static void main(String[] args) {
        PropInit.init();
        AliLiveUtils.init();
    }

    public static void init() {
        String regionId = Const.AliLive.REGIONID;
        String accessKey = Const.AliLive.ACCESSKEY;
        String accessSecret = Const.AliLive.ACCESSSECRET;
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKey, (String)accessSecret);
        client = new DefaultAcsClient((IClientProfile)profile);
    }

    public static DescribeLiveStreamsOnlineListResponse getOnlineList() {
        DescribeLiveStreamsOnlineListRequest describeLiveStreamsOnlineListRequest = new DescribeLiveStreamsOnlineListRequest();
        describeLiveStreamsOnlineListRequest.setDomainName(Const.AliLive.DOMAINNAME);
        describeLiveStreamsOnlineListRequest.setAppName(Const.AliLive.APPNAME);
        describeLiveStreamsOnlineListRequest.setProtocol(ProtocolType.HTTPS);
        describeLiveStreamsOnlineListRequest.setAcceptFormat(FormatType.JSON);
        describeLiveStreamsOnlineListRequest.setMethod(MethodType.POST);
        describeLiveStreamsOnlineListRequest.setRegionId(Const.AliLive.REGIONID);
        try {
            DescribeLiveStreamsOnlineListResponse httpResponse = (DescribeLiveStreamsOnlineListResponse)client.getAcsResponse((AcsRequest)describeLiveStreamsOnlineListRequest);
            log.info(Json.toFormatedJson((Object)httpResponse));
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static DescribeLiveStreamRecordIndexFilesResponse getRecordList(String streamname, Date startDate, Date endDate) {
        DescribeLiveStreamRecordIndexFilesRequest describeLiveStreamRecordIndexFilesRequest = new DescribeLiveStreamRecordIndexFilesRequest();
        SimpleDateFormat gmtFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        gmtFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        describeLiveStreamRecordIndexFilesRequest.setDomainName(Const.AliLive.DOMAINNAME);
        describeLiveStreamRecordIndexFilesRequest.setAppName(Const.AliLive.APPNAME);
        describeLiveStreamRecordIndexFilesRequest.setProtocol(ProtocolType.HTTPS);
        describeLiveStreamRecordIndexFilesRequest.setAcceptFormat(FormatType.JSON);
        describeLiveStreamRecordIndexFilesRequest.setStreamName(streamname);
        describeLiveStreamRecordIndexFilesRequest.setOrder("asc");
        describeLiveStreamRecordIndexFilesRequest.setMethod(MethodType.POST);
        describeLiveStreamRecordIndexFilesRequest.setRegionId(Const.AliLive.REGIONID);
        String startTime = gmtFormat.format(startDate);
        String endTime = gmtFormat.format(endDate);
        describeLiveStreamRecordIndexFilesRequest.setStartTime(startTime);
        describeLiveStreamRecordIndexFilesRequest.setEndTime(endTime);
        System.out.println(startTime);
        System.out.println(endTime);
        System.out.println(streamname);
        describeLiveStreamRecordIndexFilesRequest.setPageSize(Integer.valueOf(20));
        try {
            DescribeLiveStreamRecordIndexFilesResponse httpResponse = (DescribeLiveStreamRecordIndexFilesResponse)client.getAcsResponse((AcsRequest)describeLiveStreamRecordIndexFilesRequest);
            log.info(Json.toFormatedJson((Object)httpResponse));
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static DescribeLiveStreamOnlineUserNumResponse getOnlineUserNum(String streamname) {
        DescribeLiveStreamOnlineUserNumRequest describeLiveStreamOnlineUserNumRequest = new DescribeLiveStreamOnlineUserNumRequest();
        String domainName = Const.AliLive.DOMAINNAME;
        describeLiveStreamOnlineUserNumRequest.setDomainName(domainName);
        describeLiveStreamOnlineUserNumRequest.setAppName(Const.AliLive.APPNAME);
        describeLiveStreamOnlineUserNumRequest.setProtocol(ProtocolType.HTTPS);
        describeLiveStreamOnlineUserNumRequest.setAcceptFormat(FormatType.JSON);
        describeLiveStreamOnlineUserNumRequest.setMethod(MethodType.POST);
        describeLiveStreamOnlineUserNumRequest.setRegionId(Const.AliLive.REGIONID);
        describeLiveStreamOnlineUserNumRequest.setStreamName(streamname);
        try {
            DescribeLiveStreamOnlineUserNumResponse httpResponse = (DescribeLiveStreamOnlineUserNumResponse)client.getAcsResponse((AcsRequest)describeLiveStreamOnlineUserNumRequest);
            log.info(Json.toFormatedJson((Object)httpResponse));
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static DescribeLiveStreamsFrameRateAndBitRateDataResponse getFrameRateAndBitRateInfos(String streamname) {
        DescribeLiveStreamsFrameRateAndBitRateDataRequest describeLiveStreamsFrameRateAndBitRateDataRequest = new DescribeLiveStreamsFrameRateAndBitRateDataRequest();
        String domainName = Const.AliLive.DOMAINNAME;
        describeLiveStreamsFrameRateAndBitRateDataRequest.setDomainName(domainName);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setAppName(Const.AliLive.APPNAME);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setProtocol(ProtocolType.HTTPS);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setAcceptFormat(FormatType.JSON);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setMethod(MethodType.POST);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setRegionId(Const.AliLive.REGIONID);
        describeLiveStreamsFrameRateAndBitRateDataRequest.setStreamName(streamname);
        try {
            DescribeLiveStreamsFrameRateAndBitRateDataResponse httpResponse = (DescribeLiveStreamsFrameRateAndBitRateDataResponse)client.getAcsResponse((AcsRequest)describeLiveStreamsFrameRateAndBitRateDataRequest);
            log.info(Json.toFormatedJson((Object)httpResponse));
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static DescribeLiveStreamSnapshotInfoResponse getSnapshot(String streamname) {
        String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        DescribeLiveStreamSnapshotInfoRequest describeLiveStreamSnapshotInfoRequest = new DescribeLiveStreamSnapshotInfoRequest();
        describeLiveStreamSnapshotInfoRequest.setDomainName(Const.AliLive.DOMAINNAME);
        describeLiveStreamSnapshotInfoRequest.setAppName(Const.AliLive.APPNAME);
        describeLiveStreamSnapshotInfoRequest.setStreamName(streamname);
        describeLiveStreamSnapshotInfoRequest.setProtocol(ProtocolType.HTTPS);
        describeLiveStreamSnapshotInfoRequest.setAcceptFormat(FormatType.JSON);
        describeLiveStreamSnapshotInfoRequest.setMethod(MethodType.GET);
        describeLiveStreamSnapshotInfoRequest.setRegionId(Const.AliLive.REGIONID);
        String startTime = DateUtil.format((Date)new Date(SystemTimer.currTime - 300000L - 28800000L), (String)format);
        String endTime = DateUtil.format((Date)new Date(SystemTimer.currTime - 28800000L), (String)format);
        describeLiveStreamSnapshotInfoRequest.setStartTime(startTime);
        describeLiveStreamSnapshotInfoRequest.setEndTime(endTime);
        try {
            DescribeLiveStreamSnapshotInfoResponse httpResponse = (DescribeLiveStreamSnapshotInfoResponse)client.getAcsResponse((AcsRequest)describeLiveStreamSnapshotInfoRequest);
            if (log.isInfoEnabled()) {
                log.info("streamname:{}, response:{}", (Object)streamname, (Object)Json.toFormatedJson((Object)httpResponse));
            }
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static URL getObjectUrl(String ossObject, String ossBucket, Integer offsetMinute) {
        try {
            DefaultCredentialProvider credsProvider = new DefaultCredentialProvider(Const.AliOss.ACCESS_KEY_ID, Const.AliOss.ACCESS_KEY_SECRET);
            ClientBuilderConfiguration config = new ClientBuilderConfiguration();
            OSSClient ossClient = new OSSClient(Const.AliOss.ENDPOINT, (CredentialsProvider)credsProvider, (ClientConfiguration)config);
            URL objectUrl = ossClient.generatePresignedUrl(ossBucket, ossObject, new Date(SystemTimer.currTime + (long)(offsetMinute * 60 * 1000) + 28800000L));
            ossClient.shutdown();
            log.info(Json.toJson((Object)objectUrl));
            return objectUrl;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }

    public static ForbidLiveStreamResponse forbidLive(String streamName) {
        ForbidLiveStreamRequest forbidLiveStreamRequest = new ForbidLiveStreamRequest();
        forbidLiveStreamRequest.setDomainName(Const.AliLive.DOMAINNAME);
        forbidLiveStreamRequest.setAppName(Const.AliLive.APPNAME);
        forbidLiveStreamRequest.setProtocol(ProtocolType.HTTPS);
        forbidLiveStreamRequest.setAcceptFormat(FormatType.JSON);
        forbidLiveStreamRequest.setMethod(MethodType.POST);
        forbidLiveStreamRequest.setRegionId(Const.AliLive.REGIONID);
        forbidLiveStreamRequest.setStreamName(streamName);
        forbidLiveStreamRequest.setLiveStreamType("publisher");
        try {
            ForbidLiveStreamResponse httpResponse = (ForbidLiveStreamResponse)client.getAcsResponse((AcsRequest)forbidLiveStreamRequest);
            return httpResponse;
        }
        catch (Throwable e) {
            log.error("", e);
            return null;
        }
    }
}

