/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.service.utils;

import java.util.concurrent.Executor;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.Threads;
import org.tio.utils.http.HttpUtils;
import org.tio.utils.thread.pool.AbstractSynRunnable;

public class SitemapUtils {
    private static Logger log = LoggerFactory.getLogger(SitemapUtils.class);

    public static void main(String[] args) {
    }

    public static void pushBlog(Long blogid) throws Exception {
        SitemapUtils.push(SitemapUtils.blogBodyString(blogid));
    }

    public static void updateBlog(Long blogid) throws Exception {
        SitemapUtils.update(SitemapUtils.blogBodyString(blogid));
    }

    public static void deleteBlog(Long blogid) throws Exception {
        SitemapUtils.delete(SitemapUtils.blogBodyString(blogid));
    }

    private static String blogBodyString(Long blogid) {
        String bodyString = Const.PRODUCT_SITE + "/" + blogid;
        return bodyString;
    }

    public static void push(String bodyString) throws Exception {
        SitemapUtils.notifyBaidu("http://data.zz.baidu.com/urls?site=https://www.t-io.org&token=AYbJAHBEcjRSomPf", bodyString);
    }

    public static void update(String bodyString) throws Exception {
        SitemapUtils.notifyBaidu("http://data.zz.baidu.com/update?site=https://www.t-io.org&token=AYbJAHBEcjRSomPf", bodyString);
    }

    public static void delete(String bodyString) throws Exception {
        SitemapUtils.notifyBaidu("http://data.zz.baidu.com/del?site=https://www.t-io.org&token=AYbJAHBEcjRSomPf", bodyString);
    }

    private static void notifyBaidu(final String baiduUrl, final String bodyString) {
        int x = 6;
        if (x > 1) {
            return;
        }
        if (!Const.PRODUCT_SITE.equals(Const.SITE)) {
            return;
        }
        Threads.getTioExecutor().execute((Runnable)new AbstractSynRunnable((Executor)Threads.getTioExecutor()){

            public boolean isNeededExecute() {
                return false;
            }

            public void runTask() {
                try {
                    Response response = HttpUtils.post((String)baiduUrl, null, (String)bodyString);
                    if (response != null) {
                        log.error("\u63d0\u4ea4\u5230\u767e\u5ea6\u7edf\u8ba1\r\nurl\r\n{}\r\nbody\r\n{}\r\nresp\r\n{}", new Object[]{baiduUrl, bodyString, response.body().string()});
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
    }
}

