-- 群组服务专用
-- 用户群列表
#sql("grouplist")
	SELECT
		wg.id groupid,
		wg.`name`,
		wg.avatar,
		wg.uid,
		wgm.joinnum
	FROM
		wx_group wg
	INNER JOIN (
		SELECT
			bizid
		FROM
			wx_chat_user_item
		WHERE
			uid = #para(uid)
		AND chatmode = #para(chatmode)
		AND linkflag = #para(linkflag)
	) AS groupindex ON groupindex.bizid = wg.id
	INNER JOIN wx_group_meta wgm ON wg.id = wgm.groupid
	
	#if(nick != null && nick != "")
		where
			wg.`name` like #para(nick)
	#end
	order by wg.id desc
#end

-- 群用户列表
#sql("groupUserlist")
	SELECT
		wgu.id,
		wgu.uid,
		wgu.groupid,
		wgu.grouprole,
		wgu.srcnick,
		wgu.groupnick nick,
		wgu.groupavator avatar
	FROM
		wx_group_user wgu
	INNER JOIN (
		SELECT
			gpulinkid
		FROM
			wx_chat_group_item
		WHERE
			groupid = #para(groupid)
	) AS groupindex ON groupindex.gpulinkid = wgu.id
	#if(searchkey != null && searchkey != "")
		where  
				(
					wgu.autoflag = #para(yes)
					AND wgu.groupnick LIKE #para(searchkey)
				)
				OR (
					wgu.autoflag = #para(no)
					AND (
						wgu.srcnick LIKE #para(searchkey)
						OR wgu.groupnick LIKE #para(searchkey)
					)
				)	
	#end
	ORDER BY
		wgu.grouprole,
		wgu.id
	#if(limitnum != null && limitnum != "")
		LIMIT 0,#para(limitnum)
	#end
	
#end

-- 群用户列表
#sql("groupUserToPush")
	SELECT
		wgu.uid,
		jpush.regid
	FROM
		wx_group_user wgu
	INNER JOIN (
		SELECT
			gpulinkid
		FROM
			wx_chat_group_item
		WHERE
			groupid = #para(groupid)
	) AS groupindex ON groupindex.gpulinkid = wgu.id
	INNER JOIN wx_jpush_user jpush on jpush.uid = wgu.uid
#end


-- 群用户列表
#sql("atGroupUserlist")
	SELECT
		wgu.id,
		wgu.uid,
		wgu.groupid,
		wgu.grouprole,
		wgu.srcnick,
		wgu.groupnick nick,
		wf.remarkname,
		wgu.groupavator avatar
	FROM
		wx_group_user wgu
	INNER JOIN (
		SELECT
			gpulinkid
		FROM
			wx_chat_group_item
		WHERE
			groupid = #para(groupid)
	) AS groupindex ON groupindex.gpulinkid = wgu.id
	left join wx_friend wf on wf.uid = #para(uid) and wf.frienduid = wgu.uid
	#if(searchkey != null && searchkey != "")
		where  
				(
					wgu.autoflag = #para(yes)
					AND wgu.groupnick LIKE #para(searchkey)
				)
				OR (
					wgu.autoflag = #para(no)
					AND (
						wgu.srcnick LIKE #para(searchkey)
						OR wgu.groupnick LIKE #para(searchkey)
					)
				)
				OR (
					remarkname is not null and remarkname like #para(searchkey)
				)
				
	#end
	ORDER BY
		wgu.grouprole,
		wgu.id
	#if(limitnum != null && limitnum != "")
		LIMIT 0,#para(limitnum)
	#end
	
#end

-- 修改用户统计表
#sql("updateMeta")
	update wx_group_meta
		set 
		#if(transfercount != null && transfercount != "")
			transfercount = transfercount + #para(transfercount),
		#end
		#if(kickcount != null && kickcount != "")
			kickcount = kickcount + #para(kickcount),
		#end
		#if(leavecount != null && leavecount != "")
			leavecount = leavecount + #para(leavecount),
		#end
		#if(joinnum != null && joinnum != "")
			joinnum = joinnum + #para(joinnum),
		#end
		lastmsgid = null
		where groupid = #para(groupid)
	
#end