-- 其它人发给某用户的未读列表
#sql("n2p_notread")
SELECT
	c,
	gr.uid,
	#para(touid) as touid,
	text,
	2 as readflag,
	id
FROM
	(
		SELECT
			count(*) c,
			uid
		FROM
			im_p2p_msg
		WHERE
			touid = #para(touid)
		AND STATUS = 1
		AND readflag = 2
		and contenttype != 7
		GROUP BY
			touid,
			uid
	) gr
RIGHT JOIN (
	SELECT
		uid,
		text,
		id
	FROM
		im_p2p_msg
	WHERE
		id IN (
			SELECT
				max(id) id
			FROM
				im_p2p_msg
			WHERE
				touid = #para(touid)
			AND readflag = 2
			AND STATUS = 1
			and contenttype != 7
			GROUP BY
				uid
		)
) ma ON ma.uid = gr.uid order by id desc limit 0, #para(limit)
#end


-- 其它人发给某用户的已读列表
#sql("n2p_read")
SELECT
	uid,
	touid,
	text,
	id,
	1 AS readflag,
	readflag AS readflag2
FROM
	im_p2p_msg
WHERE
	id IN (
		SELECT
			max(id) id
		FROM
			im_p2p_msg
		WHERE
			(touid = #para(touid) OR uid = #para(touid))
		AND STATUS = 1
		and contenttype != 7
		#if(notInUidStr)
		AND uid not in ( #(notInUidStr) )
		AND touid not in ( #(notInUidStr) )
		#end
		GROUP BY
			twouid
	)
ORDER BY
	id DESC
LIMIT 0, #para(limit)
#end



