-- 是否是我的好友
#sql("isFriend")
select count(1) as c from wx_friend where (uid = #para(uid) and frienduid = #para(frienduid)) or (uid = #para(frienduid) and frienduid = #para(uid))
#end

-- 是否是我的好友
#sql("inMyFriendList")
select count(1) as c from wx_friend where uid = #para(uid) and frienduid = #para(frienduid)
#end

-- 同意或拒绝添加好友的申请
#sql("replyApplyFriend")
update wx_friend_apply_log
set `status` = #para(status), replytime = #para(replytime),
readtime = (case when `status` = 4 then #para(replytime) else readtime end )
where
	fromuid = #para(fromuid)
and touid = #para(touid)
and (`status` = 3 or `status` = 4)
#end

-- 查询两人的聊天记录
#sql("queryChatList")
	SELECT
		text as c,
		contenttype as ct,
		id as mid,
		time as t,
		touid,
		uid,
		readflag,
		sendbysys,
		readtime
	FROM
		wx_friend_msg
	WHERE
	-- 	(
	-- 		(touid = 23357 AND uid = 23357)
	-- 		OR (touid = 23357 AND uid = 23357)
	-- 	)
	twouid = #para(twouid)
	AND status = 1
	#if(startMid)
	AND id < #para(startMid)
	#end
	ORDER BY
		id DESC
	LIMIT 0, 50
#end


-- 查询我的好友
#sql("myFriends")
	select
	case when (wf.remarkname is null or wf.remarkname = '') then u.nick else wf.remarkname end as remarkname,
		u.nick,
		u.avatar,
		u.id uid
	from
		wx_friend wf,
		user u
	where
		wf.uid = #para(uid)
	and wf.frienduid = u.id
	and wf.frienduid != #para(uid)
	
	#if(nick != null)
	and (wf.remarkname like #para(nick) or u.nick like #para(nick))
	#end
	order by remarkname
#end




-- 查询我的好友并过滤掉在某群组的好友
#sql("myFriendsFilterGroup")
	select
	case when (wf.remarkname is null or wf.remarkname = '') then u.nick else wf.remarkname end as remarkname,
		u.nick,
		u.avatar,
		u.id uid
	from
		wx_friend wf,
		user u
	where
		wf.uid = #para(uid)
	and wf.frienduid != #para(uid)
	and wf.frienduid = u.id
	and wf.frienduid not in (select uid from wx_group_user where groupid = #para(groupid))
	#if(nick != null)
	and (wf.remarkname like #para(nick) or u.nick like #para(nick))
	#end
	order by remarkname
#end












-- 其它人发给某用户的未读列表
#sql("recent_msg_not_read")
SELECT
	notreadcount, gr.uid, #para(touid) as touid, text, 2 as readflag, id, time, contenttype as ct
FROM
	(
		SELECT
			count(*) notreadcount,
			uid
		FROM
			wx_friend_msg
		WHERE
			touid = #para(touid)
		AND `status` = 1
		AND readflag = 2
		GROUP BY
			touid,
			uid
	) gr
RIGHT JOIN (
	SELECT
		uid, text, id, time, contenttype
	FROM
		wx_friend_msg
	WHERE
		id IN (
			SELECT
				max(id) id
			FROM
				wx_friend_msg
			WHERE
				touid = #para(touid)
			AND readflag = 2
			AND `status` = 1
			GROUP BY
				uid
		)
) ma ON ma.uid = gr.uid order by id desc limit 0, #para(limit)
#end


-- 其它人发给某用户的已读列表
#sql("recent_msg_has_read")
SELECT
	uid, touid, text, id, time, contenttype as ct, 1 AS readflag, readflag AS readflag2
FROM
	wx_friend_msg
WHERE
	id IN (
		SELECT
			max(id) id
		FROM
			wx_friend_msg
		WHERE
			(touid = #para(touid) OR uid = #para(touid))
		AND `status` = 1
		#if(notInUidStr)
		AND uid not in ( #(notInUidStr) )
		AND touid not in ( #(notInUidStr) )
		#end
		GROUP BY
			twouid
	)
ORDER BY
	id DESC
LIMIT 0, #para(limit)
#end



