-- 某群的信息已经被某用户阅读了
#sql("updateToRead")
UPDATE wx_group_user SET lastmsgid = 
#if(lastmsgid)
	 #para(lastmsgid)
#else
	(
		SELECT max(id) FROM wx_group_msg WHERE groupid = #para(groupid)
	)
#end
WHERE
	groupid = #para(groupid)
AND uid = #para(uid)
#end


-- 某用户目前所在群
#sql("list")
select
-- 	wgu.groupnick,
-- 	wgu.createtime as jointime,
	wg.id as groupid,
	wg.uid,  -- 群主
	wg.name as groupname,
	wg.avatar as groupavatar,
-- 	wg.intro,
	wg.createtime
from
	wx_group_user wgu,
	wx_group wg
where
	wg.status = 1
and wg.id = wgu.groupid
and wgu.uid = #para(uid)
#if(groupname)
AND wg.name like '%#(groupname)%'
#end
-- order by wgm.time desc
order by wg.name
#end


-- 用户目前所在群列表
#sql("querylist")
SELECT
	wg.*, IFNULL(counttable.count, 0) count
FROM
	wx_group wg
INNER JOIN (
	SELECT
		groupid,
		count(1) count
	FROM
		wx_group_user outtable
	WHERE
		`status` = 1
	AND EXISTS (
		SELECT
			*
		FROM
			wx_group_user intable
		WHERE
			uid = #para(uid)
		AND intable. STATUS = 1
		AND outtable.groupid = intable.groupid
	)
	GROUP BY
		groupid
) AS counttable ON wg.id = counttable.groupid
#if(groupname)
	where  wg.name like '%#(groupname)%'
#end
order by wg.name

#end


-- 查询从某条消息开始的最近的聊天记录
#sql("queryChatList")
	SELECT
		wgm.text as c,
		wgm.contenttype as ct,
		wgm.id as mid,
		wgm.time as t,
		wgm.uid as f,
		wgm.groupid as g,
		wgm.sendbysys,
		wgm.device as d
	FROM
		wx_group_msg wgm,
		(
			SELECT DISTINCT
				wgu.groupid, wgu.startmsgid
			FROM
				wx_group_user wgu
			WHERE
				wgu.uid = #para(uid)
			AND wgu.groupid = #para(groupid)
		) AS wgu1
	WHERE
		wgm.groupid = wgu1.groupid
	AND wgm.groupid = #para(groupid)
	AND wgm.status = 1
	AND wgm.id > wgu1.startmsgid
	#if(startMid)
	AND wgm.id < #para(startMid)
	#end
	order by wgm.id desc
	limit 0, 50
#end


-- 群组信息，含群用户数
#sql("info")
SELECT
	wg.*, wgu.count AS membercount
FROM
	wx_group wg,
	(
		SELECT count(*) count, groupid
		FROM
			wx_group_user
		WHERE
			groupid = #para(groupid) and status = 1
	) AS wgu
WHERE
	wg.id = #para(groupid) AND wgu.groupid = wg.id and wg.status = 1
#end

#sql("member")
SELECT
	wgu.groupnick,
	wgu.uid,
	wgu.lastmsgid,
	wgu.createtime,
	u.nick,
	u.avatar
FROM
	wx_group_user wgu,
	user u
WHERE
	u.id = wgu.uid
AND groupid = #para(groupid)
and wgu.status = 1
#if(nick != null && nick != "")
	AND (
		u.nick LIKE #para(nick)
		OR wgu.groupnick LIKE #para(nick)
	)
#end
#end

-- 获取群成员列表-排序
#sql("groupUserOrderBy")
	SELECT
		wgu.groupnick,
		wgu.uid,
		wgu.lastmsgid,
		wgu.createtime,
		u.nick,
		u.avatar
	FROM
		wx_group_user wgu
		INNER JOIN `user` u on u.id = wgu.uid
		INNER JOIN wx_group wg on wg.id = wgu.groupid
	WHERE
		 groupid = #para(groupid)
		and wgu.status = 1
	order by FIELD(IF(wgu.uid = wg.uid,0,1),0,1),wgu.id
	LIMIT 0,#para(limit)
#end




-- 最近的群聊消息
#sql("recent_msg")
select wgm2.*, wgm3.notreadcount
	from
	(
		select wgm1.uid, wgm1.text, wgm1.sendbysys, wgm1.contenttype as ct, wgm1.time, wgm1.groupid, wgm1.id from wx_group_msg wgm1 where wgm1.id in
		-- 获取消息的最大id
		(
			select MAX(wgm.id) maxid from wx_group_msg wgm where wgm.groupid in 
			-- 某用户在哪些群		
			(
				SELECT wgu.groupid FROM wx_group_user wgu where wgu.uid = #para(uid) and wgu.status = 1
			) and wgm.status = 1
			group by wgm.groupid
		)
	) as wgm2, 
	(
		-- 用户所在群及未读消息数，会列出用户所在的所有群，而不管该群是否发过消息
		select wgu9.groupid, case when xx.notreadcount is null then 0 else xx.notreadcount end as notreadcount from wx_group_user wgu9 LEFT JOIN 
		(
			SELECT wgu.groupid, count(1) notreadcount FROM wx_group_user wgu, wx_group_msg wgm 
			where wgm.groupid = wgu.groupid and  wgu.uid = #para(uid) and wgu.lastmsgid < wgm.id and wgu.status = 1
			group by wgu.groupid 
		) as xx on xx.groupid = wgu9.groupid where wgu9.uid = #para(uid)
	) as wgm3
	where wgm2.groupid = wgm3.groupid
	order by wgm2.time desc
	limit 0, #para(limit)
#end



--------------------------------------------xufei-add-or-rewrite-begin------------------------------------------------


--------------------------------------------xufei-add-or-rewrite--end-------------------------------------------------