/*
 * Decompiled with CFR 0.152.
 */
package org.tio.webpack.compress;

import org.tio.webpack.compress.ResCompressor;
import org.tio.webpack.compress.css.TioCssCompressor;
import org.tio.webpack.compress.html.TioHtmlCompressor;
import org.tio.webpack.compress.js.TioJsCompressor;
import org.tio.webpack.model.Root;

public class ResCompressorFactory {
    public static ResCompressor get(String extension) {
        if ("js".equalsIgnoreCase(extension)) {
            return TioJsCompressor.me;
        }
        if ("css".equalsIgnoreCase(extension)) {
            return TioCssCompressor.me;
        }
        if ("html".equalsIgnoreCase(extension) || "htm".equalsIgnoreCase(extension)) {
            return TioHtmlCompressor.me;
        }
        return null;
    }

    public static boolean isNeedCompress(Root model, String extension) {
        if ("js".equalsIgnoreCase(extension)) {
            return model.getCompress().getJs();
        }
        if ("css".equalsIgnoreCase(extension)) {
            return model.getCompress().getCss();
        }
        if ("html".equalsIgnoreCase(extension) || "htm".equalsIgnoreCase(extension)) {
            return model.getCompress().getHtml();
        }
        return false;
    }
}

