/*
 * Decompiled with CFR 0.152.
 */
package org.tio.webpack.compress.html;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.File;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.webpack.compress.ResCompressor;
import org.tio.webpack.compress.html.HtmlOptions;

public class TioHtmlCompressor
implements ResCompressor {
    private static Logger log = LoggerFactory.getLogger(TioHtmlCompressor.class);
    private static HtmlOptions options = new HtmlOptions();
    static final String commits = "<!-- \r\n1\u3001t-io\u63d0\u4f9b\u538b\u7f29\u80fd\u529b\r\n2\u3001\u4e0d\u4ec5\u4ec5\u662f\u767e\u4e07\u7ea7\u7f51\u7edc\u7f16\u7a0b\u6846\u67b6 \uff1a https://www.tiocloud.com\r\n -->\r\n";
    public static TioHtmlCompressor me = new TioHtmlCompressor();
    HtmlCompressor compressor = null;

    public TioHtmlCompressor() {
        HtmlCompressor compressor = new HtmlCompressor();
        compressor.setEnabled(true);
        compressor.setCompressCss(false);
        compressor.setCompressJavaScript(false);
        compressor.setGenerateStatistics(false);
        compressor.setRemoveComments(options.isRemoveComments());
        compressor.setRemoveMultiSpaces(options.isRemoveMutliSpaces());
        compressor.setRemoveIntertagSpaces(options.isRemoveIntertagSpaces());
        compressor.setRemoveQuotes(options.isRemoveQuotes());
        compressor.setSimpleDoctype(options.isSimpleDoctype());
        compressor.setRemoveScriptAttributes(options.isRemoveScriptAttributes());
        compressor.setRemoveStyleAttributes(options.isRemoveStyleAttributes());
        compressor.setRemoveLinkAttributes(options.isRemoveLinkAttributes());
        compressor.setRemoveFormAttributes(options.isRemoveFormAttributes());
        compressor.setRemoveInputAttributes(options.isRemoveInputAttributes());
        compressor.setSimpleBooleanAttributes(options.isSimpleBooleanAttributes());
        compressor.setRemoveJavaScriptProtocol(options.isRemoveJavaScriptProtocol());
        compressor.setRemoveHttpProtocol(options.isRemoveHttpProtocol());
        compressor.setRemoveHttpsProtocol(options.isRemoveHttpsProtocol());
        compressor.setPreserveLineBreaks(options.isPreserveLineBreaks());
        this.compressor = compressor;
    }

    @Override
    public String compress(String filePath, String srcContent) {
        try {
            String ret = this.compressor.compress(srcContent);
            if (ret == null || ret.length() == 0) {
                log.warn("\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a0, {}", (Object)filePath);
                return srcContent;
            }
            return ret;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return srcContent;
        }
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        byte[] bytes = Files.readAllBytes(new File("E:\\\\svn\\\\nbyb\\\\html\\\\nbyb_bootstrap\\\\dist\\\\index.html").toPath());
        String xx = new String(bytes, "utf-8");
        String compiled_code = me.compress("xx.html", xx);
        System.out.println(compiled_code);
        long end = System.currentTimeMillis();
        long iv = end - start;
        System.out.println("\u8017\u65f6:" + iv + "ms");
    }
}

