/*
 * Decompiled with CFR 0.152.
 */
package org.tio.webpack.compress.js;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SysConst;
import org.tio.webpack.compress.ResCompressor;

public class TioJsCompressor
implements ResCompressor {
    private static Logger log = LoggerFactory.getLogger(TioJsCompressor.class);
    public static final TioJsCompressor me = new TioJsCompressor();
    static final String commits = "/*\r\n1\u3001t-io\u63d0\u4f9b\u538b\u7f29\u80fd\u529b\r\n2\u3001\u4e0d\u4ec5\u4ec5\u662f\u767e\u4e07\u7ea7\u7f51\u7edc\u7f16\u7a0b\u6846\u67b6 \uff1a https://www.tiocloud.com\r\n*/\r\n";

    public static void init() {
    }

    @Override
    public String compress(String srcFilePath, String srcFileContent) {
        return TioJsCompressor.compress(srcFilePath, srcFileContent, CompilerOptions.LanguageMode.ECMASCRIPT_NEXT, CompilationLevel.SIMPLE_OPTIMIZATIONS);
    }

    public static String compress(String srcFilePath, String srcFileContent, CompilerOptions.LanguageMode languageMode, CompilationLevel compilationLevel) {
        try {
            Compiler compiler = new Compiler();
            CompilerOptions options = new CompilerOptions();
            options.setLanguageIn(languageMode);
            options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setOutputCharset(SysConst.DEFAULT_CHARSET);
            List list = null;
            compilationLevel.setOptionsForCompilationLevel(options);
            try {
                list = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)CompilerOptions.Environment.BROWSER);
                list.add(SourceFile.fromCode((String)srcFilePath, (String)srcFileContent));
                ArrayList externs = new ArrayList();
                compiler.compile(externs, list, options);
                String ret = compiler.toSource();
                if (ret == null || ret.length() == 0) {
                    if (Objects.equals(compilationLevel, CompilationLevel.ADVANCED_OPTIMIZATIONS)) {
                        log.warn("\u7528{}\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a0\uff0c\u6362SIMPLE_OPTIMIZATIONS\u8bd5\u8bd5, {}", (Object)compilationLevel, (Object)srcFilePath);
                        return TioJsCompressor.compress(srcFilePath, srcFileContent, languageMode, CompilationLevel.SIMPLE_OPTIMIZATIONS);
                    }
                    if (Objects.equals(compilationLevel, CompilationLevel.SIMPLE_OPTIMIZATIONS)) {
                        log.warn("\u7528{}\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a0\uff0c\u6362WHITESPACE_ONLY\u8bd5\u8bd5, {}", (Object)compilationLevel, (Object)srcFilePath);
                        return TioJsCompressor.compress(srcFilePath, srcFileContent, languageMode, CompilationLevel.WHITESPACE_ONLY);
                    }
                    if (Objects.equals(compilationLevel, CompilationLevel.WHITESPACE_ONLY)) {
                        log.warn("\u7528{}\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a0\uff0c\u6362BUNDLE\u8bd5\u8bd5, {}", (Object)compilationLevel, (Object)srcFilePath);
                        return TioJsCompressor.compress(srcFilePath, srcFileContent, languageMode, CompilationLevel.BUNDLE);
                    }
                    log.error("\u7528{}\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a0\uff0c{}", (Object)compilationLevel, (Object)srcFilePath);
                    return srcFileContent;
                }
                return ret;
            }
            catch (IOException e) {
                log.error("Exception raised", (Throwable)e);
                return srcFileContent;
            }
        }
        catch (Exception e) {
            log.error("\u538b\u7f29" + srcFilePath + "\u65f6\u4ea7\u751f\u5f02\u5e38", (Throwable)e);
            return srcFileContent;
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            long start = System.currentTimeMillis();
            int i = 0;
            String filePath = "d:/x" + i++ + ".js";
            File initFile = new File("D:\\svn_nb\\nbyb\\html\\nbyb\\web_server\\src\\res\\js\\live\\live-all.txt");
            byte[] bytes = Files.readAllBytes(initFile.toPath());
            String content = new String(bytes, "utf-8");
            String compiled_code = me.compress(initFile.getAbsolutePath(), content);
            System.out.println(compiled_code);
            Files.write(Paths.get(filePath, new String[0]), compiled_code.getBytes("utf-8"), new OpenOption[0]);
            long end = System.currentTimeMillis();
            long iv = end - start;
            System.out.println("\u8017\u65f6:" + iv + "ms");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

