/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client;

import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.Method;
import org.tio.utils.hutool.StrUtil;
import org.tio.websocket.client.WebSocket;
import org.tio.websocket.client.WsClient;
import org.tio.websocket.client.event.CloseEvent;
import org.tio.websocket.client.event.ErrorEvent;
import org.tio.websocket.client.event.MessageEvent;
import org.tio.websocket.client.event.OpenEvent;
import org.tio.websocket.client.httpclient.ClientHttpRequest;
import org.tio.websocket.client.kit.ByteKit;
import org.tio.websocket.client.kit.ObjKit;
import org.tio.websocket.client.kit.TioKit;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsPacket;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsSessionContext;
import org.tio.websocket.common.util.BASE64Util;
import org.tio.websocket.common.util.SHA1Util;

public class WebSocketImpl
implements WebSocket {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    static final String packetPublisherKey = "__WS_PACKET_PUBLISHER__";
    static final String clientIntoCtxAttribute = "__WS_CLIENT__";
    private static final int maxBodyBytesLength = 262144;
    private volatile int readyState = 0;
    private String[] protocols = new String[0];
    private WsClient wsClient;
    private Map<String, String> additionalHttpHeaders;
    private ClientChannelContext ctx;
    private Subject<Packet> publisher = PublishSubject.create().toSerialized();
    private String secWebsocketKey = null;
    private Set<Consumer<OpenEvent>> onOpenListenerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Consumer<CloseEvent>> onCloseListenerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Consumer<ErrorEvent>> onErrorListenerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Consumer<Throwable>> onThrowsListenerSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Subject<WsPacket> sendWsPacketStream = PublishSubject.create().toSerialized();
    private Subject<Object> sendNotifier = PublishSubject.create().toSerialized();

    WebSocketImpl(WsClient wsClient) {
        this(wsClient, null);
    }

    WebSocketImpl(WsClient wsClient, Map<String, String> additionalHttpHeaders) {
        this.wsClient = wsClient;
        this.additionalHttpHeaders = additionalHttpHeaders;
        this.bindInitStreamObserver();
    }

    @Override
    public synchronized void connect() throws Exception {
        CountDownLatch wg = new CountDownLatch(1);
        int i = 1;
        while (this.wsClient.clientChannelContext == null) {
            this.wsClient.clientChannelContext = this.wsClient.tioClient.connect(new Node(this.wsClient.uri.getHost(), this.wsClient.uri.getPort()));
            if (this.wsClient.clientChannelContext != null) break;
            wg.await(10 * i, TimeUnit.MILLISECONDS);
            ++i;
        }
        this.ctx = this.wsClient.clientChannelContext;
        this.ctx.setAttribute(packetPublisherKey, this.publisher);
        this.ctx.setAttribute(clientIntoCtxAttribute, (Object)this.wsClient);
        WsSessionContext session = new WsSessionContext();
        this.ctx.set((Object)session);
        this.handshake();
    }

    @Override
    public String getExtensions() {
        return null;
    }

    @Override
    public Runnable addOnClose(Consumer<CloseEvent> listener) {
        if (listener != null) {
            this.onCloseListenerSet.add(listener);
        }
        return () -> {
            if (listener != null) {
                this.onCloseListenerSet.remove(listener);
            }
        };
    }

    @Override
    public Runnable addOnError(Consumer<ErrorEvent> listener) {
        if (listener != null) {
            this.onErrorListenerSet.add(listener);
        }
        return () -> {
            if (listener != null) {
                this.onErrorListenerSet.remove(listener);
            }
        };
    }

    @Override
    public Runnable addOnMessage(Consumer<MessageEvent> listener) {
        Disposable disposable = this.getMessageStream().map(MessageEvent::new).subscribe(listener::accept);
        return () -> ((Disposable)disposable).dispose();
    }

    @Override
    public Runnable addOnOpen(Consumer<OpenEvent> listener) {
        if (listener != null) {
            this.onOpenListenerSet.add(listener);
        }
        return () -> {
            if (listener != null) {
                this.onOpenListenerSet.remove(listener);
            }
        };
    }

    @Override
    public Runnable addOnThrows(Consumer<Throwable> listener) {
        if (listener != null) {
            this.onThrowsListenerSet.add(listener);
        }
        return () -> {
            if (listener != null) {
                this.onThrowsListenerSet.remove(listener);
            }
        };
    }

    private void onOpen() {
        OpenEvent openEvent = new OpenEvent();
        Consumer<OpenEvent> onOpen = this.wsClient.config.getOnOpen();
        if (onOpen != null) {
            onOpen.accept(openEvent);
        }
        this.onOpenListenerSet.forEach(it -> it.accept(openEvent));
        this.sendNotifier.onNext((Object)true);
    }

    private void onClose(int code, String reason) {
        this.sendWsPacketStream.onComplete();
        Consumer<CloseEvent> onClose = this.wsClient.config.getOnClose();
        if (onClose != null) {
            onClose.accept(new CloseEvent(code, reason, this.ctx.isRemoved));
        }
        this.onCloseListenerSet.forEach(it -> it.accept(new CloseEvent(code, reason, this.ctx.isRemoved)));
    }

    private void onThrows(Throwable e) {
        Consumer<Throwable> onThrows = this.wsClient.config.getOnThrows();
        if (onThrows != null) {
            onThrows.accept(e);
        }
        this.onThrowsListenerSet.forEach(it -> it.accept(e));
    }

    @Override
    public String getProtocol() {
        StringBuilder p = new StringBuilder();
        int i = 0;
        for (String proto : this.protocols) {
            p.append(proto);
            if (i != 0 && i != this.protocols.length - 1) {
                p.append(",");
            }
            ++i;
        }
        return p.toString();
    }

    @Override
    public int getReadyState() {
        return this.readyState;
    }

    @Override
    public String getUrl() {
        return this.wsClient.rawUri;
    }

    @Override
    public synchronized void close(int code, String reason) {
        if (this.readyState == 3) {
            return;
        }
        if (this.readyState != 2) {
            this.readyState = 2;
            WsPacket close = new WsPacket();
            close.setWsOpcode(Opcode.CLOSE);
            if (StrUtil.isBlank((CharSequence)reason)) {
                reason = "";
            }
            try {
                byte[] reasonBytes = reason.getBytes("UTF-8");
                short c = (short)code;
                ByteBuffer body = ByteBuffer.allocate(2 + reasonBytes.length);
                body.putShort(c);
                body.put(reasonBytes);
                close.setBody(body.array());
                close.setWsBodyLength((long)close.getBody().length);
            }
            catch (UnsupportedEncodingException reasonBytes) {
                // empty catch block
            }
            Tio.send((ChannelContext)this.ctx, (Packet)close);
            String finalReason = reason;
            Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).subscribe(i -> this.clear(code, finalReason));
        } else {
            this.clear(code, reason);
        }
    }

    synchronized void clear(int code, String reason) {
        if (this.readyState == 3) {
            return;
        }
        this.readyState = 3;
        this.publisher.onComplete();
        this.onClose(code, reason);
        try {
            this.wsClient.tioClient.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void send(String data) {
        this.send((WsPacket)WsRequest.fromText((String)data, (String)this.wsClient.config.getCharset()));
    }

    @Override
    public void send(WsPacket packet) {
        this.sendWsPacketStream.onNext((Object)packet);
        if (this.readyState == 1) {
            this.sendNotifier.onNext((Object)true);
        }
    }

    private synchronized void sendImmediately(WsPacket packet) {
        byte[] wsBody = packet.getBody();
        byte[][] wsBodies = packet.getBodys();
        int wsBodyLength = 0;
        if (wsBody != null) {
            wsBodyLength += wsBody.length;
        } else if (wsBodies != null) {
            for (byte[] bs : wsBodies) {
                wsBodyLength += bs.length;
            }
        }
        ByteBuffer bodyBuf = null;
        if (wsBody != null && wsBody.length > 0) {
            bodyBuf = ByteBuffer.wrap(wsBody);
        } else if (wsBodies != null) {
            bodyBuf = ByteBuffer.allocate(wsBodyLength);
            for (byte[] bs : wsBodies) {
                bodyBuf.put(bs);
            }
        }
        if (bodyBuf == null || wsBodyLength == 0) {
            Tio.send((ChannelContext)this.ctx, (Packet)packet);
        } else if (wsBodyLength <= 262144) {
            packet.setBody(bodyBuf.array());
            packet.setBodys((byte[][])null);
            Tio.send((ChannelContext)this.ctx, (Packet)packet);
        } else {
            byte[][] parts = ByteKit.split(bodyBuf.array(), 262144);
            for (int i = 0; i < parts.length; ++i) {
                byte[] body = parts[i];
                WsPacket sentPacket = WebSocketImpl.cloneWsPacket(packet);
                sentPacket.setBodys((byte[][])null);
                sentPacket.setBody(body);
                sentPacket.setWsBodyLength((long)body.length);
                if (i == 0) {
                    sentPacket.setWsEof(false);
                } else if (i < parts.length - 1) {
                    sentPacket.setWsEof(false);
                    sentPacket.setWsOpcode(Opcode.NOT_FIN);
                } else {
                    sentPacket.setWsEof(true);
                    sentPacket.setWsOpcode(Opcode.NOT_FIN);
                }
                TioKit.bSend((ChannelContext)this.ctx, (Packet)sentPacket, 60, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public Observable<WsPacket> getMessageStream() {
        return this.getWsPacketStream().filter(p -> p.getWsOpcode().equals((Object)Opcode.BINARY) || p.getWsOpcode().equals((Object)Opcode.TEXT));
    }

    private Observable<WsPacket> getWsPacketStream() {
        return this.publisher.filter(p -> p instanceof WsPacket).map(p -> (WsPacket)p);
    }

    private void handshake() {
        this.readyState = 0;
        ClientChannelContext ctx = this.wsClient.getClientChannelContext();
        WsSessionContext session = (WsSessionContext)ctx.get();
        session.setHandshaked(false);
        String path = this.wsClient.uri.getPath();
        if (StrUtil.isBlank((CharSequence)path)) {
            path = "/";
        }
        ClientHttpRequest httpRequest = new ClientHttpRequest(Method.GET, path, this.wsClient.uri.getRawQuery());
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.additionalHttpHeaders != null) {
            headers.putAll(this.additionalHttpHeaders);
        }
        headers.put("Host", this.wsClient.uri.getHost() + ":" + this.wsClient.uri.getPort());
        headers.put("Upgrade", "websocket");
        headers.put("Connection", "Upgrade");
        headers.put("Sec-WebSocket-Key", this.getSecWebsocketKey());
        headers.put("Sec-WebSocket-Version", "13");
        httpRequest.setHeaders(headers);
        session.setHandshakeRequest((HttpRequest)httpRequest);
        ObjKit.Box<Object> disposableBox = ObjKit.box(null);
        disposableBox.value = this.publisher.filter(packet -> !session.isHandshaked()).subscribe(packet -> {
            if (packet instanceof HttpResponse) {
                HttpResponse resp = (HttpResponse)packet;
                if (resp.getStatus() == HttpResponseStatus.C101) {
                    HeaderValue upgrade = resp.getHeader(HeaderName.Upgrade);
                    if (upgrade == null || !upgrade.value.toLowerCase().equals("websocket")) {
                        this.close(1002, "no upgrade or upgrade invalid");
                        return;
                    }
                    HeaderValue connection = resp.getHeader(HeaderName.Connection);
                    if (connection == null || !connection.value.toLowerCase().equals("upgrade")) {
                        this.close(1002, "no connection or connection invalid");
                        return;
                    }
                    HeaderValue secWebsocketAccept = resp.getHeader(HeaderName.Sec_WebSocket_Accept);
                    if (secWebsocketAccept == null || !this.verifySecWebsocketAccept(secWebsocketAccept.value)) {
                        this.close(1002, "no Sec_WebSocket_Accept or Sec_WebSocket_Accept invalid");
                        return;
                    }
                } else {
                    this.close(1002, "not support http code: " + resp.getStatus().status);
                    return;
                }
                this.readyState = 1;
                session.setHandshaked(true);
                this.onOpen();
                ((Disposable)disposableBox.value).dispose();
            }
        });
        Tio.send((ChannelContext)ctx, (Packet)httpRequest);
    }

    private String getSecWebsocketKey() {
        if (this.secWebsocketKey == null) {
            byte[] bytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                bytes[i] = (byte)(Math.random() * 256.0);
            }
            this.secWebsocketKey = BASE64Util.byteArrayToBase64((byte[])bytes);
        }
        return this.secWebsocketKey;
    }

    private boolean verifySecWebsocketAccept(String secWebsocketAccept) {
        return BASE64Util.byteArrayToBase64((byte[])SHA1Util.SHA1((String)(this.secWebsocketKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11"))).equals(secWebsocketAccept);
    }

    private void bindInitStreamObserver() {
        this.sendWsPacketStream.buffer(this.sendNotifier).subscribe(packets -> packets.forEach(this::sendImmediately), this::onThrows, () -> this.sendNotifier.onComplete());
        this.getMessageStream().subscribe(p -> {
            Consumer<MessageEvent> onMessage = this.wsClient.config.getOnMessage();
            if (onMessage != null) {
                onMessage.accept(new MessageEvent((WsPacket)p));
            }
        }, this::onThrows);
        this.getWsPacketStream().filter(p -> p.getWsOpcode().equals((Object)Opcode.CLOSE)).subscribe(packet -> {
            if (this.readyState == 3) {
                return;
            }
            byte[] body = packet.getBody();
            short code = 1000;
            String reason = "";
            if (body != null && body.length >= 2) {
                ByteBuffer bodyBuf = ByteBuffer.wrap(body);
                code = bodyBuf.getShort();
                byte[] reasonBytes = new byte[body.length - 2];
                bodyBuf.get(reasonBytes, 0, reasonBytes.length);
                reason = new String(reasonBytes, "UTF-8");
            }
            if (this.readyState == 2) {
                this.clear(code, reason);
            } else {
                this.readyState = 2;
                packet.setBody(ByteBuffer.allocate(2).putShort(code).array());
                Tio.send((ChannelContext)this.ctx, (Packet)packet);
                this.close(code, reason);
            }
        });
        this.getWsPacketStream().filter(p -> p.getWsOpcode().equals((Object)Opcode.PING)).subscribe(packet -> {
            WsPacket pong = new WsPacket();
            pong.setWsOpcode(Opcode.PONG);
            pong.setWsEof(true);
            Tio.send((ChannelContext)this.ctx, (Packet)pong);
        });
    }

    private static WsPacket cloneWsPacket(WsPacket p) {
        WsPacket packet = new WsPacket();
        packet.setHandShake(p.isHandShake());
        packet.setBody(p.getBody());
        packet.setBodys(p.getBodys());
        packet.setWsEof(p.isWsEof());
        packet.setWsOpcode(p.getWsOpcode());
        packet.setWsHasMask(p.isWsHasMask());
        packet.setWsBodyLength(p.getWsBodyLength());
        packet.setWsMask(p.getWsMask());
        packet.setWsBodyText(p.getWsBodyText());
        return packet;
    }
}

