/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.client.httpclient;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.TioDecodeException;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.ResponseLine;
import org.tio.utils.hutool.StrUtil;

public class HttpResponseDecoder {
    private static Logger log = LoggerFactory.getLogger(HttpResponseDecoder.class);
    public static final int MAX_LENGTH_OF_HEADER = 20480;
    public static final int MAX_LENGTH_OF_HEADERLINE = 2048;
    public static final int MAX_LENGTH_OF_RESPONSELINE = 2048;

    public static HttpResponse decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        HashMap<String, String> headers = new HashMap<String, String>();
        int contentLength = 0;
        byte[] bodyBytes = null;
        StringBuilder headerSb = null;
        ResponseLine firstLine = null;
        boolean appendRequestHeaderString = true;
        if (appendRequestHeaderString) {
            headerSb = new StringBuilder(512);
        }
        if ((firstLine = HttpResponseDecoder.parseResponseLine(buffer, channelContext)) == null) {
            return null;
        }
        boolean headerCompleted = HttpResponseDecoder.parseHeaderLine(buffer, headers, 0);
        if (!headerCompleted) {
            return null;
        }
        String contentLengthStr = (String)headers.get(HttpConst.ResponseHeaderKey.Content_Length);
        contentLength = StrUtil.isBlank((CharSequence)contentLengthStr) ? 0 : Integer.parseInt(contentLengthStr);
        int headerLength = buffer.position() - position;
        int allNeedLength = headerLength + contentLength;
        if (readableLength < allNeedLength) {
            channelContext.setPacketNeededLength(Integer.valueOf(allNeedLength));
            return null;
        }
        HttpResponse httpResponse = new HttpResponse();
        if (appendRequestHeaderString) {
            httpResponse.setHeaderString(headerSb.toString());
        } else {
            httpResponse.setHeaderString("");
        }
        httpResponse.setStatus(HttpResponseStatus.getHttpStatus((int)firstLine.status));
        httpResponse.addHeaders(headers.entrySet().stream().collect(Collectors.toMap(entry -> HeaderName.from((String)((String)entry.getKey())), entry -> HeaderValue.from((String)((String)entry.getValue())))));
        String connection = (String)headers.get(HttpConst.ResponseHeaderKey.Connection);
        if (connection != null) {
            // empty if block
        }
        if (contentLength != 0) {
            bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpResponse.setBody(bodyBytes);
            HttpResponseDecoder.parseBody(httpResponse, bodyBytes, channelContext);
        }
        return httpResponse;
    }

    public static void decodeParams(Map<String, Object[]> params, String queryString, String charset, ChannelContext channelContext) {
        String[] keyvalues;
        if (StrUtil.isBlank((CharSequence)queryString)) {
            return;
        }
        for (String keyvalue : keyvalues = queryString.split("&")) {
            String[] newExistValue;
            String[] keyvalueArr = keyvalue.split("=");
            if (keyvalueArr.length != 2) continue;
            String key = keyvalueArr[0];
            String value = null;
            try {
                value = URLDecoder.decode(keyvalueArr[1], charset);
            }
            catch (UnsupportedEncodingException e) {
                log.error(channelContext.toString(), (Throwable)e);
            }
            Object[] existValue = params.get(key);
            if (existValue != null) {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
                params.put(key, newExistValue);
                continue;
            }
            newExistValue = new String[]{value};
            params.put(key, newExistValue);
        }
    }

    private static void parseBody(HttpResponse httpResponse, byte[] bodyBytes, ChannelContext channelContext) throws TioDecodeException {
        if (bodyBytes != null) {
            httpResponse.setBody(bodyBytes);
        }
    }

    public static boolean parseHeaderLine(ByteBuffer buffer, Map<String, String> headers, int headerLength) throws TioDecodeException {
        int initPosition;
        byte[] allbs = buffer.array();
        int lastPosition = initPosition = buffer.position();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return false;
        }
        if (remaining > 1) {
            byte b1 = buffer.get();
            byte b2 = buffer.get();
            if (13 == b1 && 10 == b2) {
                return true;
            }
            if (10 == b1) {
                return true;
            }
        } else if (10 == buffer.get()) {
            return true;
        }
        String name = null;
        String value = null;
        boolean hasValue = false;
        boolean needIteration = false;
        while (buffer.hasRemaining()) {
            byte lastByte;
            byte b = buffer.get();
            if (name == null) {
                if (b == 58) {
                    int len = buffer.position() - lastPosition - 1;
                    name = new String(allbs, lastPosition, len);
                    lastPosition = buffer.position();
                    continue;
                }
                if (b != 10) continue;
                lastByte = buffer.get(buffer.position() - 2);
                int len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                name = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                headers.put(name.toLowerCase(), "");
                needIteration = true;
                break;
            }
            if (value != null) continue;
            if (b == 10) {
                lastByte = buffer.get(buffer.position() - 2);
                int len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                value = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                headers.put(name.toLowerCase(), StrUtil.trimEnd((CharSequence)value));
                needIteration = true;
                break;
            }
            if (!hasValue && b == 32) {
                lastPosition = buffer.position();
                continue;
            }
            hasValue = true;
        }
        if (needIteration) {
            int myHeaderLength = buffer.position() - initPosition;
            if (myHeaderLength > 20480) {
                throw new TioDecodeException("header is too long");
            }
            return HttpResponseDecoder.parseHeaderLine(buffer, headers, myHeaderLength + headerLength);
        }
        if (remaining > 2048) {
            throw new TioDecodeException("header line is too long");
        }
        return false;
    }

    public static ResponseLine parseResponseLine(ByteBuffer buffer, ChannelContext channelContext) throws TioDecodeException {
        byte[] allbs = buffer.array();
        int initPosition = buffer.position();
        String protocol = null;
        String version = null;
        Integer status = null;
        String desc = null;
        int lastPosition = initPosition;
        while (buffer.hasRemaining()) {
            int len;
            byte b = buffer.get();
            if (protocol == null) {
                if (b != 47) continue;
                len = buffer.position() - lastPosition - 1;
                protocol = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (version == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                version = new String(allbs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (status == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                String statusStr = new String(allbs, lastPosition, len);
                try {
                    status = Integer.parseInt(statusStr);
                }
                catch (NumberFormatException e) {
                    throw new TioDecodeException((Throwable)e);
                }
                lastPosition = buffer.position();
                continue;
            }
            if (desc != null || b != 10) continue;
            byte lastByte = buffer.get(buffer.position() - 2);
            int len2 = buffer.position() - lastPosition - 1;
            if (lastByte == 13) {
                len2 = buffer.position() - lastPosition - 2;
            }
            desc = new String(allbs, lastPosition, len2);
            lastPosition = buffer.position();
            ResponseLine responseLine = new ResponseLine(protocol, version, status, desc);
            return responseLine;
        }
        if (buffer.position() - initPosition > 2048) {
            throw new TioDecodeException("response line is too long");
        }
        return null;
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

