/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsPacket;

public class WsRequest
extends WsPacket {
    private static final Logger log = LoggerFactory.getLogger(WsRequest.class);
    private static final long serialVersionUID = -3361865570708714596L;

    public static WsRequest fromText(String text, String charset) {
        WsRequest wsRequest = new WsRequest();
        try {
            wsRequest.setBody(text.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        wsRequest.setWsEof(true);
        wsRequest.setWsOpcode(Opcode.TEXT);
        return wsRequest;
    }

    public static WsRequest fromBytes(byte[] bytes) {
        WsRequest wsRequest = new WsRequest();
        wsRequest.setBody(bytes);
        wsRequest.setWsEof(true);
        wsRequest.setWsOpcode(Opcode.BINARY);
        return wsRequest;
    }
}

