/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.table;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.table.RawColumn;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.util.CommonUtils;

public class RawTable {
    private final TachyonFS mTachyonFS;
    private final ClientRawTableInfo mClientRawTableInfo;

    public RawTable(TachyonFS tachyonClient, ClientRawTableInfo clientRawTableInfo) {
        this.mTachyonFS = tachyonClient;
        this.mClientRawTableInfo = clientRawTableInfo;
    }

    public int getColumns() {
        return this.mClientRawTableInfo.getColumns();
    }

    public int getId() {
        return this.mClientRawTableInfo.getId();
    }

    public ByteBuffer getMetadata() {
        return CommonUtils.cloneByteBuffer(this.mClientRawTableInfo.metadata);
    }

    public String getName() {
        return this.mClientRawTableInfo.getName();
    }

    public String getPath() {
        return this.mClientRawTableInfo.getPath();
    }

    public RawColumn getRawColumn(int columnIndex) {
        Preconditions.checkArgument((columnIndex >= 0 && columnIndex < this.mClientRawTableInfo.getColumns() ? 1 : 0) != 0, (Object)(this.mClientRawTableInfo.getPath() + " does not have column " + columnIndex + ". It has " + this.mClientRawTableInfo.getColumns() + " columns."));
        return new RawColumn(this.mTachyonFS, this, columnIndex);
    }

    public void updateMetadata(ByteBuffer metadata) throws IOException {
        this.mTachyonFS.updateRawTableMetadata(this.mClientRawTableInfo.getId(), metadata);
        this.mClientRawTableInfo.setMetadata(CommonUtils.cloneByteBuffer(metadata));
    }
}

