/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.RemoteBlockReader;
import tachyon.network.protocol.RPCResponse;
import tachyon.worker.DataServerMessage;

public final class TCPRemoteBlockReader
implements RemoteBlockReader {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readRemoteBlock(String host, int port, long blockId, long offset, long length) throws IOException {
        InetSocketAddress address = new InetSocketAddress(host, port);
        SocketChannel socketChannel = SocketChannel.open();
        try {
            socketChannel.connect(address);
            LOG.info("Connected to remote machine " + address);
            DataServerMessage sendMsg = DataServerMessage.createBlockRequestMessage(blockId, offset, length);
            while (!sendMsg.finishSending()) {
                sendMsg.send(socketChannel);
            }
            LOG.info("Data " + blockId + " to remote machine " + address + " sent");
            DataServerMessage recvMsg = DataServerMessage.createBlockResponseMessage(false, blockId, null);
            while (!recvMsg.isMessageReady()) {
                int numRead = recvMsg.recv(socketChannel);
                if (numRead != -1) continue;
                LOG.warn("Read nothing");
                if (recvMsg.isMessageReady()) continue;
                LOG.error("Response was not received completely.");
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            LOG.info("Data " + blockId + " from remote machine " + address + " received");
            if (recvMsg.getStatus() != RPCResponse.Status.SUCCESS) {
                LOG.warn("Error in response for blockId: " + recvMsg.getBlockId() + " message: " + recvMsg.getStatus().getMessage());
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = recvMsg.getReadOnlyData();
            return byteBuffer;
        }
        finally {
            socketChannel.close();
        }
    }
}

