/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring3.expression.Fields;
import org.thymeleaf.spring3.expression.SpelEvaluationContext;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpelVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    public static final SpelVariableExpressionEvaluator INSTANCE = new SpelVariableExpressionEvaluator();
    private static final String SPEL_CACHE_PREFIX = "{spel}";
    public static final String FIELDS_EVALUATION_VARIABLE_NAME = "fields";
    private static final Logger logger = LoggerFactory.getLogger(SpelVariableExpressionEvaluator.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final StandardEvaluationContext DEFAULT_EVALUATION_CONTEXT = new StandardEvaluationContext();

    protected SpelVariableExpressionEvaluator() {
    }

    public final Object evaluate(Configuration configuration, IProcessingContext processingContext, String spelExpression, boolean useSelectionAsRoot) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] SpringEL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)spelExpression);
        }
        try {
            Map<String, Object> contextVariables = this.computeContextVariables(configuration, processingContext);
            SpelEvaluationContext context = new SpelEvaluationContext((EvaluationContext)DEFAULT_EVALUATION_CONTEXT, contextVariables);
            SpelExpression exp = SpelVariableExpressionEvaluator.getExpression(configuration, spelExpression);
            Object evaluationRoot = useSelectionAsRoot ? processingContext.getExpressionSelectionEvaluationRoot() : processingContext.getExpressionEvaluationRoot();
            return exp.getValue((EvaluationContext)context, evaluationRoot);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating SpringEL expression: \"" + spelExpression + "\"", (Throwable)e);
        }
    }

    private static SpelExpression getExpression(Configuration configuration, String spelExpression) {
        SpelExpression exp = null;
        ICache cache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            exp = (SpelExpression)cache.get((Object)(SPEL_CACHE_PREFIX + spelExpression));
        }
        if (exp == null) {
            exp = (SpelExpression)PARSER.parseExpression(spelExpression);
            if (cache != null && null != exp) {
                cache.put((Object)(SPEL_CACHE_PREFIX + spelExpression), (Object)exp);
            }
        }
        return exp;
    }

    public Map<String, Object> computeContextVariables(Configuration configuration, IProcessingContext processingContext) {
        HashMap<String, Object> contextVariables = new HashMap<String, Object>();
        Map expressionObjects = processingContext.getExpressionObjects();
        if (expressionObjects != null) {
            contextVariables.putAll(expressionObjects);
        }
        Fields fields = new Fields(configuration, processingContext);
        contextVariables.put(FIELDS_EVALUATION_VARIABLE_NAME, fields);
        Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(processingContext);
        if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
            contextVariables.putAll(additionalContextVariables);
        }
        return contextVariables;
    }

    protected Map<String, Object> computeAdditionalContextVariables(IProcessingContext processingContext) {
        return Collections.emptyMap();
    }

    public String toString() {
        return "SpringEL";
    }
}

