/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.linkbuilder.webflux;

import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;
import org.thymeleaf.spring5.context.webflux.ISpringWebFluxContext;

public class SpringWebFluxLinkBuilder
extends StandardLinkBuilder {
    protected String computeContextPath(IExpressionContext context, String base, Map<String, Object> parameters) {
        if (!(context instanceof ISpringWebFluxContext)) {
            throw new TemplateProcessingException("Link base \"" + base + "\" cannot be context relative (/...) unless the context used for executing the engine implements the " + ISpringWebFluxContext.class.getName() + " interface");
        }
        ServerHttpRequest request = ((ISpringWebFluxContext)context).getRequest();
        return request.getPath().contextPath().value();
    }

    protected String processLink(IExpressionContext context, String link) {
        if (!(context instanceof ISpringWebFluxContext)) {
            return link;
        }
        ServerWebExchange exchange = ((ISpringWebFluxContext)context).getExchange();
        return exchange.transformUrl(link);
    }
}

