/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam;

import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlbeam.XBProjector;
import org.xmlbeam.dom.DOMAccess;
import org.xmlbeam.util.intern.DOMHelper;

class DefaultDOMAccessInvoker
implements DOMAccess,
Serializable {
    private final Node documentOrElement;
    private final Class<?> projectionInterface;
    private final XBProjector projector;

    private DefaultDOMAccessInvoker(Node documentOrElement, Class<?> projectionInterface, XBProjector projector) {
        this.documentOrElement = documentOrElement;
        this.projectionInterface = projectionInterface;
        this.projector = projector;
    }

    @Override
    public Class<?> getProjectionInterface() {
        return this.projectionInterface;
    }

    @Override
    public Node getDOMNode() {
        return this.documentOrElement;
    }

    @Override
    public Document getDOMOwnerDocument() {
        return DOMHelper.getOwnerDocumentFor(this.documentOrElement);
    }

    @Override
    public Element getDOMBaseElement() {
        if (9 == this.documentOrElement.getNodeType()) {
            return ((Document)this.documentOrElement).getDocumentElement();
        }
        assert (1 == this.documentOrElement.getNodeType());
        return (Element)this.documentOrElement;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DOMAccess)) {
            return false;
        }
        DOMAccess op = (DOMAccess)o;
        if (!this.projectionInterface.equals(op.getProjectionInterface())) {
            return false;
        }
        return DOMHelper.nodesAreEqual(this.documentOrElement, op.getDOMNode());
    }

    public int hashCode() {
        return 31 * this.projectionInterface.hashCode() + 27 * DOMHelper.nodeHashCode(this.documentOrElement);
    }

    @Override
    public String asString() {
        try {
            StringWriter writer = new StringWriter();
            this.projector.config().createTransformer(new Document[0]).transform(new DOMSource(this.getDOMNode()), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static DefaultDOMAccessInvoker create(Class<?> projectionInterface, Node node, XBProjector projector, boolean toStringRendersXML) {
        return toStringRendersXML ? new XMLRenderingObjectInvoker(projectionInterface, node, projector) : new DefaultObjectInvoker(projectionInterface, node, projector);
    }

    @Override
    public DOMAccess create(String path, Object value) {
        throw new IllegalStateException("This method should not be called.");
    }

    static final class XMLRenderingObjectInvoker
    extends DefaultDOMAccessInvoker {
        private XMLRenderingObjectInvoker(Class<?> projectionInterface, Node documentOrElement, XBProjector projector) {
            super(documentOrElement, projectionInterface, projector);
        }

        public String toString() {
            return super.asString();
        }
    }

    static final class DefaultObjectInvoker
    extends DefaultDOMAccessInvoker {
        private DefaultObjectInvoker(Class<?> projectionInterface, Node documentOrElement, XBProjector projector) {
            super(documentOrElement, projectionInterface, projector);
        }

        public String toString() {
            String typeDesc = this.getDOMNode().getNodeType() == 9 ? "document '" + this.getDOMNode().getBaseURI() + "'" : "element '" + this.getDOMNode().getNodeName() + "[" + Integer.toString(this.getDOMNode().hashCode(), 16) + "]'";
            return "Projection [" + this.getProjectionInterface().getName() + "]" + " to " + typeDesc;
        }
    }
}

