/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xmlbeam.XBProjector;
import org.xmlbeam.evaluation.CanEvaluate;
import org.xmlbeam.evaluation.DefaultXPathEvaluator;
import org.xmlbeam.evaluation.DocumentResolver;
import org.xmlbeam.evaluation.XPathEvaluator;

public class XBStreamInput
implements CanEvaluate {
    private final XBProjector projector;
    private final InputStream is;
    private String systemID;

    public XBStreamInput(XBProjector xmlProjector, InputStream is) {
        this.projector = xmlProjector;
        this.is = is;
    }

    public <T> T read(Class<T> projectionInterface) throws IOException {
        Document document = this.readDocument();
        return this.projector.projectDOMNode(document, projectionInterface);
    }

    private Document readDocument() throws IOException {
        try {
            DocumentBuilder documentBuilder = this.projector.config().createDocumentBuilder();
            Document document = this.systemID == null ? documentBuilder.parse(this.is) : documentBuilder.parse(this.is, this.systemID);
            return document;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public XBStreamInput setSystemID(String systemID) {
        this.systemID = systemID;
        return this;
    }

    @Override
    public XPathEvaluator evalXPath(String xpath) {
        return new DefaultXPathEvaluator(this.projector, new DocumentResolver(){

            @Override
            public Document resolve(Class<?> ... resourceAwareClass) {
                try {
                    return XBStreamInput.this.readDocument();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, xpath);
    }
}

