/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.jmxtools;

import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import mx4j.adaptor.http.HttpCommandProcessor;
import org.jcontainer.dna.AbstractLogEnabled;
import org.jcontainer.dna.Active;
import org.jcontainer.dna.Composable;
import org.jcontainer.dna.Configurable;
import org.jcontainer.dna.Configuration;
import org.jcontainer.dna.ConfigurationException;
import org.jcontainer.dna.MissingResourceException;
import org.jcontainer.dna.ResourceLocator;
import org.realityforge.jmxtools.UserConfig;

public class DefaultMX4JWebConsole
extends AbstractLogEnabled
implements Composable,
Configurable,
Active {
    private static final String ADDRESS_SECTION = "bindAddress";
    private static final String PORT_SECTION = "port";
    private static final String USERS_SECTION = "users";
    private static final String USER_SECTION = "user";
    private static final String NAME_SECTION = "name";
    private static final String PASSWORD_SECTION = "password";
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_PORT = 8080;
    private static final String[] ADD_AUTH_PARAM_TYPES = new String[]{(class$java$lang$String == null ? (class$java$lang$String = DefaultMX4JWebConsole.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = DefaultMX4JWebConsole.class$("java.lang.String")) : class$java$lang$String).getName()};
    private static final String[] ADD_PROCESSOR_PARAM_TYPES = new String[]{(class$java$lang$String == null ? (class$java$lang$String = DefaultMX4JWebConsole.class$("java.lang.String")) : class$java$lang$String).getName(), (class$mx4j$adaptor$http$HttpCommandProcessor == null ? (class$mx4j$adaptor$http$HttpCommandProcessor = DefaultMX4JWebConsole.class$("mx4j.adaptor.http.HttpCommandProcessor")) : class$mx4j$adaptor$http$HttpCommandProcessor).getName()};
    private MBeanServer _mBeanServer;
    private String _address;
    private int _port;
    private UserConfig[] _users;
    private ObjectName _httpName;
    private ObjectName _processorName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$mx4j$adaptor$http$HttpCommandProcessor;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public void compose(ResourceLocator locator) throws MissingResourceException {
        if (locator.contains((class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = DefaultMX4JWebConsole.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getName())) {
            this._mBeanServer = (MBeanServer)locator.lookup((class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = DefaultMX4JWebConsole.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getName());
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._address = configuration.getChild(ADDRESS_SECTION).getValue(DEFAULT_ADDRESS);
        this._port = configuration.getChild(PORT_SECTION).getValueAsInteger(8080);
        Configuration[] children = configuration.getChild(USERS_SECTION).getChildren(USER_SECTION);
        this._users = new UserConfig[children.length];
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String username = child.getChild(NAME_SECTION).getValue();
            String password = child.getChild(PASSWORD_SECTION).getValue();
            this._users[i] = new UserConfig(username, password);
        }
    }

    public void initialize() throws Exception {
        if (null == this._mBeanServer) {
            ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
            if (1 == list.size()) {
                this._mBeanServer = list.get(0);
            } else {
                String message = "No MBeanServer specified for WebConsole and multiple MBeanServers found in JVM. Unable to determine which MBeanServer to use.";
                this.getLogger().error("No MBeanServer specified for WebConsole and multiple MBeanServers found in JVM. Unable to determine which MBeanServer to use.");
                throw new Exception("No MBeanServer specified for WebConsole and multiple MBeanServers found in JVM. Unable to determine which MBeanServer to use.");
            }
        }
        this.setupHttpAdaptor();
        this.setupCommandProcessors();
        this.setupProcessor();
        try {
            this._mBeanServer.invoke(this._httpName, "start", null, null);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to start the MX Server.  Verify that the port '" + this._port + "' is available", (Throwable)e);
            throw e;
        }
    }

    private void setupHttpAdaptor() throws Exception {
        this.getLogger().info("Starting Http Adaptor on " + this._address + ":" + this._port);
        this._httpName = new ObjectName("Http:name=HttpAdaptor");
        this._mBeanServer.createMBean("mx4j.adaptor.http.HttpAdaptor", this._httpName, null);
        this._mBeanServer.setAttribute(this._httpName, new Attribute("Host", this._address));
        this._mBeanServer.setAttribute(this._httpName, new Attribute("Port", new Integer(this._port)));
        this._mBeanServer.setAttribute(this._httpName, new Attribute("AuthenticationMethod", "basic"));
        for (int i = 0; i < this._users.length; ++i) {
            UserConfig user = this._users[i];
            Object[] params = new Object[]{user.getUsername(), user.getPassword()};
            this._mBeanServer.invoke(this._httpName, "addAuthorization", params, ADD_AUTH_PARAM_TYPES);
        }
    }

    protected void setupProcessor() throws Exception {
        this._processorName = new ObjectName("Http:name=XSLTProcessor");
        this._mBeanServer.createMBean("mx4j.adaptor.http.XSLTProcessor", this._processorName, null);
        this._mBeanServer.setAttribute(this._httpName, new Attribute("ProcessorName", this._processorName));
    }

    protected void setupCommandProcessors() throws Exception {
    }

    public void dispose() throws Exception {
        if (null != this._httpName && this._mBeanServer.isRegistered(this._httpName)) {
            this._mBeanServer.invoke(this._httpName, "stop", null, null);
            this._mBeanServer.unregisterMBean(this._httpName);
        }
        if (null != this._processorName && this._mBeanServer.isRegistered(this._processorName)) {
            this._mBeanServer.unregisterMBean(this._processorName);
        }
    }

    protected final void addCommandProcessor(String name, HttpCommandProcessor processor) throws Exception {
        this.getmBeanServer().invoke(this.getHttpName(), "addCommandProcessor", new Object[]{name, processor}, ADD_PROCESSOR_PARAM_TYPES);
    }

    protected final ObjectName getHttpName() {
        return this._httpName;
    }

    protected final ObjectName getProcessorName() {
        return this._processorName;
    }

    protected final MBeanServer getmBeanServer() {
        return this._mBeanServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

