/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtil {
    public static final String VIEW = "/view.json";
    public static final String SCHEMA_FOLDER = "/schema/";
    public static final String SCHEMA = "/schema/schema.json";
    public static final String ELEMENTS_SCHEMA = "/schema/elements.json";
    public static final String TYPES_SCHEMA = "/schema/types.json";
    public static final String STORE_PROPERTIES = "/store.properties";
    public static final String GRAPH_CONFIG = "/graphConfig.json";
    public static final String FAILED_TO_CREATE_INPUT_STREAM_FOR_PATH = "Failed to create input stream for path: ";
    public static final String LOG_FAILED_TO_CREATE_INPUT_STREAM_FOR_PATH = "Failed to create input stream for path: {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtil.class);

    private StreamUtil() {
    }

    public static InputStream graphConfig(Class clazz) {
        return StreamUtil.openStream(clazz, GRAPH_CONFIG);
    }

    public static InputStream view(Class clazz) {
        return StreamUtil.openStream(clazz, VIEW);
    }

    public static InputStream[] schemas(Class clazz) {
        return StreamUtil.openStreams(clazz, SCHEMA_FOLDER);
    }

    public static InputStream schema(Class clazz) {
        return StreamUtil.openStream(clazz, SCHEMA);
    }

    public static InputStream elementsSchema(Class clazz) {
        return StreamUtil.openStream(clazz, ELEMENTS_SCHEMA);
    }

    public static InputStream typesSchema(Class clazz) {
        return StreamUtil.openStream(clazz, TYPES_SCHEMA);
    }

    public static InputStream storeProps(Class clazz) {
        return StreamUtil.openStream(clazz, STORE_PROPERTIES);
    }

    public static InputStream[] openStreams(Class clazz, String folderPath) {
        if (null == folderPath) {
            return new InputStream[0];
        }
        String folderPathChecked = StreamUtil.getFormattedPath(folderPath);
        HashSet inputStreams = Sets.newHashSet();
        new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(new URL[]{ClasspathHelper.forClass((Class)clazz, (ClassLoader[])new ClassLoader[0])})).getResources(Pattern.compile(".*")).stream().filter(file -> file.startsWith(folderPathChecked)).forEach(file -> {
            try {
                inputStreams.add(StreamUtil.openStream(clazz, file));
            }
            catch (Exception e) {
                int closedStreamsCount = StreamUtil.closeStreams(inputStreams.toArray(new InputStream[inputStreams.size()]));
                LOGGER.info(String.format("Closed %s input streams", closedStreamsCount));
            }
        });
        if (inputStreams.isEmpty()) {
            throw new IllegalArgumentException("No file could be found in path: " + folderPath);
        }
        return inputStreams.toArray(new InputStream[inputStreams.size()]);
    }

    private static String getFormattedPath(String folderPath) {
        String folderPathChecked;
        String string = folderPathChecked = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        if (folderPathChecked.startsWith("/")) {
            folderPathChecked = folderPathChecked.substring(1);
        }
        return folderPathChecked;
    }

    public static InputStream[] openStreams(URI ... uris) throws IOException {
        InputStream[] schemas = new InputStream[uris.length];
        for (int pos = 0; pos < uris.length; ++pos) {
            try {
                schemas[pos] = StreamUtil.openStream(uris[pos]);
                continue;
            }
            catch (Exception e) {
                int closedStreamsCount = StreamUtil.closeStreams(schemas);
                LOGGER.info("Closed {} input streams", (Object)closedStreamsCount);
                throw e;
            }
        }
        return schemas;
    }

    public static InputStream openStream(URI uri) throws IOException {
        try {
            return uri.toURL().openStream();
        }
        catch (IOException e) {
            LOGGER.error("Failed to create input stream: {}", (Object)uri, (Object)e);
            throw e;
        }
    }

    public static int closeStreams(InputStream ... inputStreams) {
        int closedStreamsCount = 0;
        for (InputStream stream : inputStreams) {
            try {
                stream.close();
            }
            catch (Exception e) {
                LOGGER.debug("Exception while closing input streams", (Throwable)e);
            }
            ++closedStreamsCount;
        }
        return closedStreamsCount;
    }

    public static InputStream openStream(Class clazz, String path) throws IllegalArgumentException {
        String checkedPath = StreamUtil.formatPathForOpenStream(path);
        InputStream resourceAsStream = clazz.getResourceAsStream(checkedPath);
        return null != resourceAsStream ? resourceAsStream : StreamUtil.processException(path);
    }

    private static InputStream processException(String path) throws IllegalArgumentException {
        LOGGER.error(LOG_FAILED_TO_CREATE_INPUT_STREAM_FOR_PATH, (Object)path);
        throw new IllegalArgumentException(FAILED_TO_CREATE_INPUT_STREAM_FOR_PATH + path);
    }

    public static String formatPathForOpenStream(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            StreamUtil.processException(path);
        }
        return path.startsWith("/") ? path : "/" + path;
    }
}

