/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import uk.gov.gchq.koryphe.serialisation.json.SimpleClassNameIdResolver;

public final class StringUtil {
    public static final char COMMA = ',';
    private static final char ESCAPE_CHAR = '\\';
    private static final char REPLACEMENT_CHAR = ';';

    private StringUtil() {
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert bytes to string", e);
        }
    }

    public static byte[] toBytes(String string) {
        if (null == string) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert bytes to string", e);
        }
    }

    public static String escapeComma(String str) {
        StringBuilder escapedStr = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('\\' == c) {
                escapedStr.append('\\');
                escapedStr.append(';');
                continue;
            }
            if (',' == c) {
                escapedStr.append('\\');
                escapedStr.append('\\');
                continue;
            }
            escapedStr.append(c);
        }
        return escapedStr.toString();
    }

    public static String unescapeComma(String escapedStr) {
        StringBuilder str = new StringBuilder(escapedStr.length());
        boolean isEscaped = false;
        for (int i = 0; i < escapedStr.length(); ++i) {
            char c = escapedStr.charAt(i);
            if (isEscaped) {
                if (';' == c) {
                    str.append('\\');
                } else if ('\\' == c) {
                    str.append(',');
                } else {
                    str.append(c);
                }
                isEscaped = false;
                continue;
            }
            if ('\\' == c) {
                isEscaped = true;
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static byte[] toCsv(Class<?> ... classes) {
        Object[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        return StringUtil.toBytes(StringUtils.join((Object[])classNames, (String)","));
    }

    public static <T> Set<Class<? extends T>> csvToClasses(byte[] bytes, Class<? extends T> clazz) {
        String[] classNames = StringUtil.toString(bytes).split(",");
        HashSet<Class<T>> classes = new HashSet<Class<T>>(classNames.length);
        for (String className : classNames) {
            try {
                classes.add(Class.forName(SimpleClassNameIdResolver.getClassName((String)className)).asSubclass(clazz));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid class: " + className + ". Should be an implementation of " + clazz.getName(), e);
            }
        }
        return classes;
    }

    public static String nullIfEmpty(String string) {
        return null != string && string.isEmpty() ? null : string;
    }
}

