/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.elementvisibilityutil;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import uk.gov.gchq.gaffer.commonutil.elementvisibilityutil.ArrayByteSequence;

public class Authorisations
implements Iterable<byte[]>,
Serializable {
    private static final long serialVersionUID = 8931467369628123909L;
    private Set<ArrayByteSequence> auths = new HashSet<ArrayByteSequence>();
    private List<byte[]> authsList = new ArrayList<byte[]>();
    private static final boolean[] VALID_AUTH_CHARS;
    public static final String HEADER = "!AUTH1:";

    public Authorisations() {
    }

    public Authorisations(String ... authorisations) {
        this.setAuthorisations(authorisations);
    }

    public Authorisations(byte[] authorisations) {
        Preconditions.checkArgument((authorisations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        String authsString = new String(authorisations, StandardCharsets.UTF_8);
        if (authsString.startsWith(HEADER)) {
            if ((authsString = authsString.substring(HEADER.length())).length() > 0) {
                for (String encAuth : authsString.split(",")) {
                    byte[] auth = Base64.getDecoder().decode(encAuth);
                    this.auths.add(new ArrayByteSequence(auth));
                }
                this.checkAuths();
            }
        } else if (authorisations.length > 0) {
            this.setAuthorisations(authsString.split(","));
        }
    }

    public List<byte[]> getAuthorisations() {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(bytes);
        }
        return Collections.unmodifiableList(copy);
    }

    public byte[] getAuthorisationsArray() {
        return this.serialise().getBytes(StandardCharsets.UTF_8);
    }

    public List<ByteBuffer> getAuthorisationsBB() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(ByteBuffer.wrap(bytes));
        }
        return Collections.unmodifiableList(copy);
    }

    public String serialise() {
        StringBuilder sb = new StringBuilder(HEADER);
        String sep = "";
        for (byte[] auth : this.authsList) {
            sb.append(sep);
            sep = ",";
            sb.append(Base64.getEncoder().encodeToString(auth));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (ArrayByteSequence auth : this.auths) {
            sb.append(sep);
            sep = ",";
            sb.append(new String(auth.toArray(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public boolean contains(byte[] auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    public boolean contains(ArrayByteSequence auth) {
        return this.auths.contains(auth);
    }

    public boolean contains(String auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Authorisations) {
            Authorisations ao = (Authorisations)o;
            return this.auths.equals(ao.auths);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (ArrayByteSequence b : this.auths) {
            result += b.hashCode();
        }
        return result;
    }

    public int size() {
        return this.auths.size();
    }

    public boolean isEmpty() {
        return this.auths.isEmpty();
    }

    @Override
    public Iterator<byte[]> iterator() {
        return this.getAuthorisations().iterator();
    }

    static final boolean isValidAuthChar(byte b) {
        return VALID_AUTH_CHARS[0xFF & b];
    }

    private void checkAuths() {
        TreeSet<ArrayByteSequence> sortedAuths = new TreeSet<ArrayByteSequence>(this.auths);
        for (ArrayByteSequence bs : sortedAuths) {
            if (bs.length() == 0) {
                throw new IllegalArgumentException("Empty authorisation");
            }
            this.authsList.add(bs.toArray());
        }
    }

    private void setAuthorisations(String ... authorisations) {
        Preconditions.checkArgument((authorisations != null ? 1 : 0) != 0, (Object)"authorisations is null");
        this.auths.clear();
        String[] var2 = authorisations;
        int var3 = authorisations.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String str = var2[var4];
            str = str.trim();
            this.auths.add(new ArrayByteSequence(str.getBytes(StandardCharsets.UTF_8)));
        }
        this.checkAuths();
    }

    static {
        int i;
        VALID_AUTH_CHARS = new boolean[256];
        for (i = 0; i < 256; ++i) {
            Authorisations.VALID_AUTH_CHARS[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            Authorisations.VALID_AUTH_CHARS[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            Authorisations.VALID_AUTH_CHARS[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            Authorisations.VALID_AUTH_CHARS[i] = true;
        }
        Authorisations.VALID_AUTH_CHARS[95] = true;
        Authorisations.VALID_AUTH_CHARS[45] = true;
        Authorisations.VALID_AUTH_CHARS[58] = true;
        Authorisations.VALID_AUTH_CHARS[46] = true;
        Authorisations.VALID_AUTH_CHARS[47] = true;
    }
}

