/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;

public class ConsumableBlockingQueue<T>
extends ArrayBlockingQueue<T> {
    private static final long serialVersionUID = 4048319404021495269L;

    public ConsumableBlockingQueue(int maxSize) {
        super(maxSize);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !ConsumableBlockingQueue.this.isEmpty();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more items");
                }
                return ConsumableBlockingQueue.this.poll();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumableBlockingQueue queue = (ConsumableBlockingQueue)obj;
        return new EqualsBuilder().append(this.toArray(), queue.toArray()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 47).append(this.toArray()).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("items", this.toArray()).toString();
    }
}

