/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.iterable;

import java.util.Collections;
import java.util.Iterator;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.CloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.EmptyClosableIterable;
import uk.gov.gchq.gaffer.commonutil.iterable.EmptyCloseableIterator;
import uk.gov.gchq.gaffer.commonutil.iterable.WrappedCloseableIterator;

public class WrappedCloseableIterable<T>
implements CloseableIterable<T> {
    private final Iterable<T> iterable;

    public WrappedCloseableIterable() {
        this(Collections.emptyList());
    }

    public WrappedCloseableIterable(Iterable<T> iterable) {
        this.iterable = null == iterable ? new EmptyClosableIterable() : iterable;
    }

    public WrappedCloseableIterable(Iterator<T> iterator) {
        this.iterable = null == iterator ? EmptyCloseableIterator::new : () -> iterator;
    }

    @Override
    public void close() {
        CloseableUtil.close(this.iterable);
    }

    @Override
    public CloseableIterator<T> iterator() {
        Iterator<T> iterator = this.iterable.iterator();
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new WrappedCloseableIterator<T>(iterator);
    }

    public String toString() {
        return new ToStringBuilder(this).append("iterable", this.iterable).toString();
    }
}

