/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil.stream;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import uk.gov.gchq.gaffer.commonutil.CloseableUtil;
import uk.gov.gchq.gaffer.commonutil.stream.StreamSupplier;
import uk.gov.gchq.gaffer.commonutil.stream.Streams;

public class MapStreamSupplier<T, U>
implements StreamSupplier<U> {
    private final Iterable<T> input;
    private final Function<T, U> function;

    public MapStreamSupplier(Iterable<T> input, Function<T, U> function) {
        this.input = input;
        this.function = function;
    }

    @Override
    public void close() throws IOException {
        CloseableUtil.close(this.input);
    }

    @Override
    public Stream<U> get() {
        return Streams.toStream(this.input).map(this.function);
    }
}

