/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmpp;

import java.io.IOException;
import java.util.Iterator;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.soap.SoapVersionFactory;
import org.codehaus.xfire.xmpp.SoapEnvelopePacket;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SoapIQProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        try {
            return new SoapEnvelopePacket(this.parseDocument(parser).asXML());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected Document parseDocument(XmlPullParser pp) throws DocumentException, IOException, XmlPullParserException {
        DocumentFactory df = DocumentFactory.getInstance();
        Document document = df.createDocument();
        Element parent = null;
        int depth = pp.getDepth();
        int type = pp.getEventType();
        while (true) {
            switch (type) {
                case 8: {
                    String text = pp.getText();
                    int loc = text.indexOf(" ");
                    if (loc >= 0) {
                        String target = text.substring(0, loc);
                        String txt = text.substring(loc + 1);
                        document.addProcessingInstruction(target, txt);
                        break;
                    }
                    document.addProcessingInstruction(text, "");
                    break;
                }
                case 9: {
                    if (parent != null) {
                        parent.addComment(pp.getText());
                        break;
                    }
                    document.addComment(pp.getText());
                    break;
                }
                case 5: {
                    if (parent != null) {
                        parent.addCDATA(pp.getText());
                        break;
                    }
                    String msg = "Cannot have text content outside of the root document";
                    throw new DocumentException(msg);
                }
                case 6: {
                    break;
                }
                case 1: {
                    return document;
                }
                case 2: {
                    int i;
                    QName qname = pp.getPrefix() == null ? df.createQName(pp.getName(), pp.getNamespace()) : df.createQName(pp.getName(), pp.getPrefix(), pp.getNamespace());
                    Element newElement = df.createElement(qname);
                    int nsStart = pp.getNamespaceCount(pp.getDepth() - 1);
                    int nsEnd = pp.getNamespaceCount(pp.getDepth());
                    for (i = nsStart; i < nsEnd; ++i) {
                        if (pp.getNamespacePrefix(i) == null) continue;
                        newElement.addNamespace(pp.getNamespacePrefix(i), pp.getNamespaceUri(i));
                    }
                    for (i = 0; i < pp.getAttributeCount(); ++i) {
                        QName qa = pp.getAttributePrefix(i) == null ? df.createQName(pp.getAttributeName(i)) : df.createQName(pp.getAttributeName(i), pp.getAttributePrefix(i), pp.getAttributeNamespace(i));
                        newElement.addAttribute(qa, pp.getAttributeValue(i));
                    }
                    if (parent != null) {
                        parent.add(newElement);
                    } else {
                        document.add(newElement);
                    }
                    parent = newElement;
                    break;
                }
                case 3: {
                    if (parent != null) {
                        parent = parent.getParent();
                    }
                    if (pp.getDepth() > depth || parent != null) break;
                    return document;
                }
                case 4: {
                    String text = pp.getText();
                    if (parent != null) {
                        parent.addText(text);
                        break;
                    }
                    String msg = "Cannot have text content outside of the root document";
                    throw new DocumentException(msg);
                }
            }
            type = pp.nextToken();
        }
    }

    static {
        SoapIQProvider provider = new SoapIQProvider();
        Iterator itr = SoapVersionFactory.getInstance().getVersions();
        while (itr.hasNext()) {
            SoapVersion version = (SoapVersion)itr.next();
            ProviderManager.addIQProvider((String)version.getEnvelope().getLocalPart(), (String)version.getEnvelope().getNamespaceURI(), (Object)provider);
        }
    }
}

