/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.log;

import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.hanweb.common.BaseInfo;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.LogStopWatch;
import com.hanweb.common.util.log.ThreadLocalHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LogWriter
extends LineOfCallerConverter {
    public static LogStopWatch getLogStopWatch() {
        return new LogStopWatch();
    }

    private static void a(Level level, Object object, Throwable throwable) {
        ThreadLocalHolder.createTraceId(null);
        if (LogWriter.a(throwable)) {
            LogWriter.b(level, object, null);
        } else if (throwable != null) {
            if (BaseInfo.getInstance() != null && BaseInfo.getInstance().isDetailErrorLog()) {
                LogWriter.b(level, object, throwable);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                if (object == null) {
                    stringBuffer.append("SYSTEM ").append(level.toString());
                } else {
                    stringBuffer.append(String.valueOf(object));
                }
                stringBuffer.append(" , ");
                stringBuffer.append(String.valueOf(throwable));
                LogWriter.b(level, stringBuffer.toString(), null);
            }
        } else {
            LogWriter.b(level, object, throwable);
        }
    }

    private static void b(Level level, Object object, Throwable throwable) {
        switch (level) {
            case DEBUG: {
                LogWriter.a().debug(StringUtil.getString(object), throwable);
                break;
            }
            case ERROR: {
                LogWriter.a().error(StringUtil.getString(object), throwable);
                break;
            }
            case INFO: {
                LogWriter.a().info(StringUtil.getString(object), throwable);
                break;
            }
            case TRACE: {
                LogWriter.a().trace(StringUtil.getString(object), throwable);
                break;
            }
            case WARN: {
                LogWriter.a().warn(StringUtil.getString(object), throwable);
            }
        }
    }

    private static String a(String string, Object ... objectArray) {
        if (StringUtil.isEmpty(string) && objectArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("{").append(i).append("}").append(" ");
            }
            String string2 = stringBuffer.toString();
            string = new StringBuilder(47).append("log format is empty,log values:").append(string2).toString();
        }
        string = StringUtil.messageFormat(string, objectArray);
        return string;
    }

    @Deprecated
    public static void trace(Object object) {
        LogWriter.a(Level.TRACE, object, null);
    }

    @Deprecated
    public static void trace(String string, Object ... objectArray) {
        LogWriter.a(Level.TRACE, (Object)LogWriter.a(string, objectArray), null);
    }

    @Deprecated
    public static void trace(Object object, Throwable throwable) {
        LogWriter.a(Level.TRACE, object, throwable);
    }

    @Deprecated
    public static void trace(Throwable throwable, String string, Object ... objectArray) {
        LogWriter.a(Level.TRACE, (Object)LogWriter.a(string, objectArray), throwable);
    }

    @Deprecated
    public static void debug(Object object) {
        LogWriter.a(Level.DEBUG, object, null);
    }

    @Deprecated
    public static void debug(String string, Object ... objectArray) {
        LogWriter.a(Level.DEBUG, (Object)LogWriter.a(string, objectArray), null);
    }

    @Deprecated
    public static void debug(Object object, Throwable throwable) {
        LogWriter.a(Level.DEBUG, object, throwable);
    }

    @Deprecated
    public static void debug(Throwable throwable, String string, Object ... objectArray) {
        LogWriter.a(Level.DEBUG, (Object)LogWriter.a(string, objectArray), throwable);
    }

    @Deprecated
    public static void info(Object object) {
        LogWriter.a(Level.INFO, object, null);
    }

    @Deprecated
    public static void info(String string, Object ... objectArray) {
        LogWriter.a(Level.INFO, (Object)LogWriter.a(string, objectArray), null);
    }

    @Deprecated
    public static void info(Object object, Throwable throwable) {
        LogWriter.a(Level.INFO, object, throwable);
    }

    @Deprecated
    public static void info(Throwable throwable, String string, Object ... objectArray) {
        LogWriter.a(Level.INFO, (Object)LogWriter.a(string, objectArray), throwable);
    }

    @Deprecated
    public static void warn(Object object) {
        LogWriter.a(Level.WARN, object, null);
    }

    @Deprecated
    public static void warn(String string, Object ... objectArray) {
        LogWriter.a(Level.WARN, (Object)LogWriter.a(string, objectArray), null);
    }

    @Deprecated
    public static void warn(Object object, Throwable throwable) {
        LogWriter.a(Level.WARN, object, throwable);
    }

    @Deprecated
    public static void warn(Throwable throwable, String string, Object ... objectArray) {
        LogWriter.a(Level.WARN, (Object)LogWriter.a(string, objectArray), throwable);
    }

    @Deprecated
    public static void error(Object object) {
        LogWriter.a(Level.ERROR, object, null);
    }

    @Deprecated
    public static void error(String string, Object ... objectArray) {
        LogWriter.a(Level.ERROR, (Object)LogWriter.a(string, objectArray), null);
    }

    @Deprecated
    public static void error(Object object, Throwable throwable) {
        LogWriter.a(Level.ERROR, object, throwable);
    }

    @Deprecated
    public static void error(Throwable throwable, String string, Object ... objectArray) {
        LogWriter.a(Level.ERROR, (Object)LogWriter.a(string, objectArray), throwable);
    }

    private static boolean a(Throwable throwable) {
        boolean bl = false;
        if (throwable != null) {
            String string = throwable.getClass().getName();
            bl = StringUtil.contains(string, "ClientAbortException");
        }
        return bl;
    }

    private static Logger a() {
        String string = "";
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            string = stackTraceElementArray[5].getClassName();
        }
        catch (Exception exception) {
            string = LogWriter.class.getName();
        }
        return LoggerFactory.getLogger((String)string);
    }

    public static boolean isDebug(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz).isDebugEnabled();
    }

    public static boolean isWarn(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz).isWarnEnabled();
    }

    public static boolean isInfo(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz).isInfoEnabled();
    }

    public static boolean isError(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz).isErrorEnabled();
    }

    public static boolean isTrace(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz).isTraceEnabled();
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        StackTraceElement[] stackTraceElementArray = iLoggingEvent.getCallerData();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (stackTraceElement.getClassName() != iLoggingEvent.getLoggerName()) continue;
                n = i;
                break;
            }
            return Integer.toString(stackTraceElementArray[n].getLineNumber());
        }
        return "?";
    }

    public static void setOprUser(String string) {
        ThreadLocalHolder.setLocalOprUser(string);
    }
}

