/*
 * Decompiled with CFR 0.152.
 */
package com.gm.sm2;

import com.gm.sm2.SM2Constants;
import com.gm.sm2.SM2SignResult;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2Helper {
    public static byte[] encrypt(byte[] byArray, ECPublicKeyParameters eCPublicKeyParameters, SM2Engine.Mode mode) throws Exception {
        SM2Engine sM2Engine = new SM2Engine(mode);
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)eCPublicKeyParameters, new SecureRandom());
        sM2Engine.init(true, (CipherParameters)parametersWithRandom);
        return sM2Engine.processBlock(byArray, 0, byArray.length);
    }

    public static byte[] decrypt(byte[] byArray, ECPrivateKeyParameters eCPrivateKeyParameters, SM2Engine.Mode mode) throws Exception {
        SM2Engine sM2Engine = new SM2Engine(mode);
        sM2Engine.init(false, (CipherParameters)eCPrivateKeyParameters);
        return sM2Engine.processBlock(byArray, 0, byArray.length);
    }

    public static SM2SignResult sign(byte[] byArray, ECPrivateKeyParameters eCPrivateKeyParameters, byte[] byArray2) throws Exception {
        SM2Signer sM2Signer = new SM2Signer();
        Object object = byArray2 != null && byArray2.length > 0 ? new ParametersWithID((CipherParameters)eCPrivateKeyParameters, byArray2) : eCPrivateKeyParameters;
        sM2Signer.init(true, (CipherParameters)object);
        sM2Signer.update(byArray, 0, byArray.length);
        byte[] byArray3 = sM2Signer.generateSignature();
        SM2SignResult sM2SignResult = new SM2SignResult();
        sM2SignResult.decodeStandardDSA(byArray3);
        return sM2SignResult;
    }

    public static boolean verifySign(byte[] byArray, SM2SignResult sM2SignResult, ECPublicKeyParameters eCPublicKeyParameters, byte[] byArray2) throws Exception {
        BigInteger bigInteger = new BigInteger(1, sM2SignResult.getSignR());
        BigInteger bigInteger2 = new BigInteger(1, sM2SignResult.getSignS());
        byte[] byArray3 = StandardDSAEncoding.INSTANCE.encode(SM2Constants.SM2_ECC_N, bigInteger, bigInteger2);
        SM2Signer sM2Signer = new SM2Signer();
        Object object = byArray2 != null && byArray2.length > 0 ? new ParametersWithID((CipherParameters)eCPublicKeyParameters, byArray2) : eCPublicKeyParameters;
        sM2Signer.init(false, (CipherParameters)object);
        sM2Signer.update(byArray, 0, byArray.length);
        return sM2Signer.verifySignature(byArray3);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

