/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.security;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import com.hanweb.common.util.security.MatrixToImageConfig;
import com.hanweb.common.util.security.MatrixToImageWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class QrcodeMaker {
    private Log a = LogFactory.getInstance(this.getClass());
    private int b = -16777216;
    private int c = -1;
    private int d = 0;
    private int e = 100;
    private int f = 100;
    private int g = 12;
    private int h = 12;
    private Color i = Color.BLACK;
    private int j = 0;
    private Map<EncodeHintType, Object> k = new HashMap<EncodeHintType, Object>(){
        {
            this.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            this.put(EncodeHintType.CHARACTER_SET, "utf-8");
            this.put(EncodeHintType.MARGIN, 0);
        }
    };

    public void addParam(EncodeHintType encodeHintType, Object object) {
        this.k.put(encodeHintType, object);
    }

    public QrcodeMaker() {
    }

    public QrcodeMaker(int n) {
        this.e = n;
        this.f = n;
    }

    public QrcodeMaker(int n, int n2) {
        this.e = n;
        this.f = n2;
    }

    public QrcodeMaker(int n, int n2, int n3, int n4) {
        this.e = n;
        this.f = n2;
        this.b = n3;
        this.c = n4;
    }

    public void drawLogoQRCode(String string, HttpServletResponse httpServletResponse) {
        this.drawLogoQRCode(string, null, httpServletResponse);
    }

    public void drawLogoQRCode(String string, String string2, HttpServletResponse httpServletResponse) {
        this.drawLogoQRCode(string, string2, null, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLogoQRCode(String string, String string2, File file, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("image/png");
        httpServletResponse.setHeader("cache", "no-cache");
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            this.a(string, string2, file, null, (OutputStream)servletOutputStream);
        }
        catch (Exception exception) {
            this.a.error((Object)"drawLogoQRCode error", (Throwable)exception);
        }
        finally {
            if (servletOutputStream != null) {
                IOUtils.closeQuietly((OutputStream)servletOutputStream);
            }
        }
    }

    public void drawLogoQRCode(String string, OutputStream outputStream) {
        this.drawLogoQRCode(string, null, outputStream);
    }

    public void drawLogoQRCode(String string, String string2, OutputStream outputStream) {
        this.drawLogoQRCode(string, string2, null, outputStream);
    }

    public void drawLogoQRCode(String string, String string2, File file, OutputStream outputStream) {
        this.a(string, string2, file, null, outputStream);
    }

    public void drawLogoQRCode(String string, File file) {
        this.drawLogoQRCode(string, null, file);
    }

    public void drawLogoQRCode(String string, String string2, File file) {
        this.drawLogoQRCode(string, string2, null, file);
    }

    public void drawLogoQRCode(String string, String string2, File file, File file2) {
        this.a(string, string2, file, file2, null);
    }

    private void a(String string, String string2, File file, File file2, OutputStream outputStream) {
        try {
            int n;
            Object object;
            Object object2;
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bitMatrix = multiFormatWriter.encode(string, BarcodeFormat.QR_CODE, this.e, this.f, this.k);
            bitMatrix = this.a(bitMatrix);
            MatrixToImageConfig matrixToImageConfig = new MatrixToImageConfig(this.b, this.c);
            Object object3 = MatrixToImageWriter.toBufferedImage(bitMatrix, matrixToImageConfig);
            object3 = this.zoomInImage((BufferedImage)object3, this.e, this.f);
            if (file != null && file.exists()) {
                object2 = ((BufferedImage)object3).createGraphics();
                object = ImageIO.read(file);
                n = ((BufferedImage)object).getWidth();
                int n2 = ((BufferedImage)object).getHeight();
                if (n > this.e / 3) {
                    n = this.e / 3;
                }
                if (n2 > this.f / 3) {
                    n2 = this.f / 3;
                }
                int n3 = (this.e - n) / 2;
                int n4 = (this.f - n2) / 2;
                ((Graphics)object2).drawImage((Image)object, n3, n4, n, n2, null);
                ((Graphics)object2).dispose();
                ((Image)object).flush();
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                object2 = new BufferedImage(this.e, this.f + this.h + this.j * 2, 2);
                object = ((BufferedImage)object2).createGraphics();
                ((Graphics)object).drawImage((Image)object3, 0, 0, this.e, this.f, null);
                ((Graphics)object).setColor(this.i);
                ((Graphics)object).setFont(new Font("\u5b8b\u4f53", 0, this.g));
                n = ((Graphics)object).getFontMetrics().stringWidth(string2);
                ((Graphics2D)object).drawString(string2, (this.e - n) / 2, this.f + this.h + this.j - 2);
                ((Graphics)object).dispose();
                ((Image)object2).flush();
                object3 = object2;
            }
            ((Image)object3).flush();
            if (file2 != null) {
                ImageIO.write((RenderedImage)object3, "png", file2);
            } else if (outputStream != null) {
                ImageIO.write((RenderedImage)object3, "png", outputStream);
            }
        }
        catch (Exception exception) {
            this.a.error((Object)"drawLogoQRCode error", (Throwable)exception);
        }
    }

    public void setColor(int n) {
        this.b = n;
    }

    public void setBgColor(int n) {
        this.c = n;
    }

    public void setWidth(int n) {
        this.e = n;
    }

    public void setHeight(int n) {
        this.f = n;
    }

    public void setFontSize(int n) {
        this.g = n;
    }

    public void setFontHeight(int n) {
        this.h = n;
    }

    public void setFontColor(Color color) {
        this.i = color;
    }

    public void setHints(Map<EncodeHintType, Object> map) {
        this.k = map;
    }

    public void setMargin(int n) {
        this.d = n;
    }

    public void setFontMargin(int n) {
        this.j = n;
    }

    private BitMatrix a(BitMatrix bitMatrix) {
        int n = this.d * 2;
        int[] nArray = bitMatrix.getEnclosingRectangle();
        int n2 = nArray[2] + n + 1;
        int n3 = nArray[3] + n + 1;
        BitMatrix bitMatrix2 = new BitMatrix(n2, n3);
        bitMatrix2.clear();
        for (int i = this.d; i < n2 - this.d; ++i) {
            for (int j = this.d; j < n3 - this.d; ++j) {
                if (!bitMatrix.get(i - this.d + nArray[0], j - this.d + nArray[1])) continue;
                bitMatrix2.set(i, j);
            }
        }
        return bitMatrix2;
    }

    public BufferedImage zoomInImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static int getIntFromColor(int n, int n2, int n3) {
        n = n << 16 & 0xFF0000;
        n2 = n2 << 8 & 0xFF00;
        return 0xFF000000 | n | n2 | (n3 &= 0xFF);
    }
}

