/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;

public class CharsetUtil {
    private static Log a = LogFactory.getInstance(CharsetUtil.class);
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";
    public static final String GB2312 = "GB2312";

    public static String toASCII(String string) {
        return CharsetUtil.changeCharset(string, Charsets.ASCII);
    }

    public static String toISO_8859_1(String string) {
        return CharsetUtil.changeCharset(string, Charsets.ISO_8859_1);
    }

    public static String toUTF_8(String string) {
        return CharsetUtil.changeCharset(string, Charsets.UTF_8);
    }

    public static String toUTF_16BE(String string) {
        return CharsetUtil.changeCharset(string, Charsets.UTF_16BE);
    }

    public static String toUTF_16LE(String string) {
        return CharsetUtil.changeCharset(string, Charsets.UTF_16LE);
    }

    public static String toUTF_16(String string) {
        return CharsetUtil.changeCharset(string, Charsets.UTF_16);
    }

    public static String toGBK(String string) {
        return CharsetUtil.changeCharset(string, Charsets.GBK);
    }

    public static String toGB2312(String string) {
        return CharsetUtil.changeCharset(string, Charsets.GB2312);
    }

    public static String changeCharset(String string, Charsets charsets) {
        String string2 = CharsetUtil.convert(charsets);
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            byte[] byArray = string.getBytes();
            try {
                string = new String(byArray, string2);
            }
            catch (Exception exception) {
                a.error((Object)"changeCharset error", (Throwable)exception);
            }
        }
        return string;
    }

    public static String changeCharset(String string, Charsets charsets, Charsets charsets2) {
        String string2 = CharsetUtil.convert(charsets);
        String string3 = CharsetUtil.convert(charsets2);
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2) && StringUtil.isNotEmpty((String)string3)) {
            try {
                byte[] byArray = string.getBytes(string2);
                string = new String(byArray, string3);
            }
            catch (Exception exception) {
                a.error((Object)"changeCharset error", (Throwable)exception);
            }
        }
        return string;
    }

    public static String convert(Charsets charsets) {
        String string = null;
        if (charsets != null) {
            switch (charsets) {
                case ASCII: {
                    string = US_ASCII;
                    break;
                }
                case GB2312: {
                    string = GB2312;
                    break;
                }
                case GBK: {
                    string = GBK;
                    break;
                }
                case ISO_8859_1: {
                    string = ISO_8859_1;
                    break;
                }
                case UTF_16: {
                    string = UTF_16;
                    break;
                }
                case UTF_16BE: {
                    string = UTF_16BE;
                    break;
                }
                case UTF_16LE: {
                    string = UTF_16LE;
                    break;
                }
                case UTF_8: {
                    string = UTF_8;
                }
            }
        }
        return string;
    }

    public static enum Charsets {
        ASCII,
        ISO_8859_1,
        UTF_8,
        UTF_16BE,
        UTF_16LE,
        UTF_16,
        GBK,
        GB2312;

    }
}

