/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CollectionUtil {
    public static boolean isEmpty(Collection collection) {
        return CollectionUtils.isEmpty((Collection)collection);
    }

    public static boolean isNotEmpty(Collection collection) {
        return CollectionUtils.isNotEmpty((Collection)collection);
    }

    public static <T> List<T> subList(List<T> list, int n, int n2) {
        return CollectionUtil.subList(list, n, n2, true);
    }

    public static <T> List<T> subList(List<T> list, int n, int n2, boolean bl) {
        if (CollectionUtil.isNotEmpty(list)) {
            int n3;
            if (n < 0) {
                n = 0;
            }
            if (bl && n2 > (n3 = list.size())) {
                n2 = n3;
            }
            return list.subList(n, n2);
        }
        return list;
    }

    public static int size(Collection collection) {
        if (CollectionUtil.isNotEmpty(collection)) {
            return CollectionUtils.size((Object)collection);
        }
        return 0;
    }

    public static boolean contains(Collection collection, Object object) {
        if (CollectionUtil.isNotEmpty(collection)) {
            return collection.contains(object);
        }
        return false;
    }

    public static Collection union(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return null;
        }
        return CollectionUtils.union((Collection)collection, (Collection)collection2);
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return null;
        }
        return CollectionUtils.intersection((Collection)collection, (Collection)collection2);
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return null;
        }
        return CollectionUtils.disjunction((Collection)collection, (Collection)collection2);
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        if (collection == null || collection2 == null) {
            return null;
        }
        return CollectionUtils.subtract((Collection)collection, (Collection)collection2);
    }

    public static <T> List<T> removeRepeat(List<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        HashSet<T> hashSet = new HashSet<T>(list);
        ArrayList<T> arrayList = new ArrayList<T>(hashSet);
        return arrayList;
    }

    public static <T> List<T> contact(List<T> list, List<T> list2) {
        if (list == null && list == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<T>();
        }
        if (list2 == null) {
            list2 = new ArrayList<T>();
        }
        ArrayList<T> arrayList = new ArrayList<T>(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public <T> Set<T> ToHashSet(Collection<T> collection) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        return hashSet;
    }

    public <T> List<T> ToList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        return arrayList;
    }

    public static <T> List<T> createSynchronizedList() {
        ArrayList arrayList = new ArrayList();
        return Collections.synchronizedList(arrayList);
    }

    public static <T> Set<T> createSynchronizedSet() {
        HashSet hashSet = new HashSet();
        return Collections.synchronizedSet(hashSet);
    }

    public static <T> List<T> createList(T ... TArray) {
        ArrayList<T> arrayList = null;
        if (TArray != null) {
            arrayList = new ArrayList<T>();
            for (T t : TArray) {
                arrayList.add(t);
            }
        }
        return arrayList;
    }

    public static <T> Set<T> createSet(T ... TArray) {
        HashSet<T> hashSet = null;
        if (TArray != null) {
            hashSet = new HashSet<T>();
            for (T t : TArray) {
                hashSet.add(t);
            }
        }
        return hashSet;
    }

    public static boolean inScope(Collection<?> collection, int n) {
        return n < collection.size();
    }

    public static <T> T get(Collection<T> collection, int n) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        if (!CollectionUtil.inScope(collection, n)) {
            return null;
        }
        return (T)CollectionUtils.get(collection, (int)n);
    }

    public static <T extends Comparable> void sort(List<T> list, Sort sort) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Collections.sort(list);
        if (sort != null && sort == Sort.DESC) {
            Collections.reverse(list);
        }
    }

    public static <T extends Comparable> void sort(List<T> list, Comparator<T> comparator) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Collections.sort(list, comparator);
    }

    public static <T> int indexOf(List<T> list, T t) {
        if (CollectionUtil.isEmpty(list)) {
            return -1;
        }
        return list.indexOf(t);
    }

    public static <T> int lastIndexOf(List<T> list, T t) {
        if (CollectionUtil.isEmpty(list)) {
            return -1;
        }
        return list.lastIndexOf(t);
    }

    public static enum Sort {
        ASC,
        DESC;

    }
}

