/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FreemarkerUtil {
    private static Log a = LogFactory.getInstance(FreemarkerUtil.class);
    private static Configuration b = null;

    public static synchronized void initFreemarker() {
        if (b != null) {
            return;
        }
        b = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        b.setDefaultEncoding("utf-8");
        b.setOutputEncoding("utf-8");
        b.setEncoding(Locale.getDefault(), "utf-8");
        b.setCacheStorage((CacheStorage)new MruCacheStorage(20, 10000));
        try {
            b.setNumberFormat("0.##");
            b.setSetting("template_update_delay", "3600");
            b.setSetting("whitespace_stripping", "true");
            b.setSetting("url_escaping_charset", "utf-8");
            b.setSetting("date_format", "yyyy-MM-dd");
            b.setSetting("time_format", "HH:mm:ss");
            b.setClassicCompatible(true);
            b.setSetting("datetime_format", "yyyy-MM-dd HH:mm:ss");
        }
        catch (TemplateException templateException) {
            a.error((Object)templateException);
        }
    }

    public static void setDebug(boolean bl) {
        try {
            if (b != null) {
                if (bl) {
                    b.setSetting("template_update_delay", "0");
                } else {
                    b.setSetting("template_update_delay", "3600");
                }
            }
        }
        catch (TemplateException templateException) {
            a.error((Object)templateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processFTL(String string, Map<String, ?> map) {
        StringWriter stringWriter = new StringWriter();
        Template template = null;
        String string2 = null;
        try {
            template = b.getTemplate(string);
            template.process(map, (Writer)stringWriter);
            string2 = stringWriter.toString();
        }
        catch (Exception exception) {
            a.error((Object)exception);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                a.warn((Object)iOException);
            }
        }
        return string2;
    }

    public static String processFTL(String string, String string2, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string2, object);
        return FreemarkerUtil.processFTL(string, hashMap);
    }
}

