/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.name.Rename;

public class ImageHandle
extends Rename {
    private static Log a = LogFactory.getInstance(ImageHandle.class);
    public static final Positions BOTTOM_CENTER = Positions.BOTTOM_CENTER;
    public static final Positions BOTTOM_LEFT = Positions.BOTTOM_LEFT;
    public static final Positions BOTTOM_RIGHT = Positions.BOTTOM_RIGHT;
    public static final Positions CENTER = Positions.CENTER;
    public static final Positions CENTER_LEFT = Positions.CENTER_LEFT;
    public static final Positions CENTER_RIGHT = Positions.CENTER_RIGHT;
    public static final Positions TOP_CENTER = Positions.TOP_CENTER;
    public static final Positions TOP_LEFT = Positions.TOP_LEFT;
    public static final Positions TOP_RIGHT = Positions.TOP_RIGHT;
    private Thumbnails.Builder<?> b;
    private String c;
    private String d;
    private int e = 0;
    private int f = 0;
    private double g = 1.0;
    private boolean h = false;
    private BufferedImage i = null;

    private ImageHandle(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            a.error((Object)"imageFile is null OR not exists");
            return;
        }
        try {
            this.i = ImageIO.read(file);
            this.b = Thumbnails.of((File[])new File[]{file});
        }
        catch (Exception exception) {
            a.error((Object)"imageFile error", (Throwable)exception);
        }
        this.a();
    }

    private ImageHandle(InputStream inputStream) {
        try {
            this.i = ImageIO.read(inputStream);
            this.b = Thumbnails.of((BufferedImage[])new BufferedImage[]{this.i});
        }
        catch (Exception exception) {
            a.error((Object)"inputStream error", (Throwable)exception);
        }
        this.a();
    }

    private ImageHandle(BufferedImage bufferedImage) {
        try {
            this.b = Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage});
        }
        catch (Exception exception) {
            a.error((Object)"inputStream error", (Throwable)exception);
        }
        this.a();
    }

    private void a() {
        this.b.useExifOrientation(true);
        try {
            this.e = this.i.getWidth();
            this.f = this.i.getHeight();
        }
        catch (Exception exception) {
            a.error((Object)"init image error", (Throwable)exception);
        }
    }

    public static ImageHandle getInstance(File file) {
        return new ImageHandle(file);
    }

    public static ImageHandle getInstance(String string) {
        return new ImageHandle(new File(string));
    }

    public static ImageHandle getInstance(InputStream inputStream) {
        return new ImageHandle(inputStream);
    }

    public static ImageHandle getInstance(BufferedImage bufferedImage) {
        return new ImageHandle(bufferedImage);
    }

    public int getWidth() {
        return this.e;
    }

    public int getHeight() {
        return this.f;
    }

    public void setSize(int n, int n2) {
        this.b.size(n, n2);
        this.h = true;
    }

    public void setOutputFormat(String string) {
        this.b.outputFormat(string);
    }

    public void setRotate(double d) {
        this.b.rotate(d);
    }

    public void setOutputQuality(double d) {
        this.g = d;
    }

    public void setScale(double d) {
        this.b.scale(d);
        this.h = true;
    }

    public void setCut(int n, int n2, int n3, int n4) {
        this.b.sourceRegion(n, n2, n3, n4);
    }

    public void setWatermark(File file, Position position, float f) {
        try {
            this.b.watermark(position, ImageIO.read(file), f);
        }
        catch (Exception exception) {
            a.error((Object)"\u6c34\u5370\u6587\u4ef6\u6253\u5f00\u5931\u8d25", (Throwable)exception);
        }
    }

    public void setWatermark(InputStream inputStream, Position position, float f) {
        try {
            this.b.watermark(position, ImageIO.read(inputStream), f);
        }
        catch (Exception exception) {
            a.error((Object)"\u6c34\u5370\u6587\u4ef6\u6253\u5f00\u5931\u8d25", (Throwable)exception);
        }
    }

    public void setSuffix(String string) {
        this.c = string;
    }

    public void setPrefix(String string) {
        this.d = string;
    }

    private void b() {
        if (!this.h) {
            this.b.width(this.e);
            this.b.height(this.f);
        }
        this.b.outputQuality(this.g);
    }

    public void save(File file) {
        try {
            this.b();
            this.b.toFile(file);
        }
        catch (Exception exception) {
            a.error((Object)"\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)exception);
        }
    }

    public void toOutputStream(OutputStream outputStream) {
        try {
            this.b();
            this.b.toOutputStream(outputStream);
        }
        catch (Exception exception) {
            a.error((Object)"\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)exception);
        }
    }

    public void save() {
        try {
            this.b();
            this.b.toFiles((Rename)this);
        }
        catch (Exception exception) {
            a.error((Object)"\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)exception);
        }
    }

    public BufferedImage toBufferedImage() {
        BufferedImage bufferedImage = null;
        try {
            this.b();
            bufferedImage = this.b.asBufferedImage();
        }
        catch (Exception exception) {
            a.error((Object)"toBufferedImage error", (Throwable)exception);
        }
        return bufferedImage;
    }

    public String apply(String string, ThumbnailParameter thumbnailParameter) {
        if (StringUtil.isNotEmpty((String)this.d)) {
            string = this.appendPrefix(string, this.d);
        }
        if (StringUtil.isNotEmpty((String)this.c)) {
            string = this.appendSuffix(string, this.c);
        }
        return string;
    }
}

