/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import java.math.BigDecimal;
import org.apache.commons.lang.RandomStringUtils;

public class MathUtil {
    public static final int DEFAULT_DIV_SCALE = 2;

    public static String randomNumeric(Integer n) {
        return RandomStringUtils.randomNumeric((int)n);
    }

    public static double add(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.add(bigDecimal2).doubleValue();
    }

    public static String add(String string, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        return bigDecimal.add(bigDecimal2).toString();
    }

    public static double subtract(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.subtract(bigDecimal2).doubleValue();
    }

    public static String subtract(String string, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        return bigDecimal.subtract(bigDecimal2).toString();
    }

    public static double multiply(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.multiply(bigDecimal2).doubleValue();
    }

    public static String multiply(String string, String string2) {
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        return bigDecimal.multiply(bigDecimal2).toString();
    }

    public static double divide(double d, double d2) {
        return MathUtil.divide(d, d2, 2);
    }

    public static double divide(double d, double d2, int n) {
        return MathUtil.divide(d, d2, n, 6);
    }

    public static double divide(double d, double d2, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.divide(bigDecimal2, n, n2).doubleValue();
    }

    public static String divide(String string, String string2) {
        return MathUtil.divide(string, string2, 2);
    }

    public static String divide(String string, String string2, int n) {
        return MathUtil.divide(string, string2, n, 6);
    }

    public static String divide(String string, String string2, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(string2);
        return bigDecimal.divide(bigDecimal2, n, n2).toString();
    }

    public static double round(double d, int n) {
        return MathUtil.round(d, n, 6);
    }

    public static double round(double d, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        return bigDecimal.setScale(n, n2).doubleValue();
    }

    public static float round(float f, int n) {
        return MathUtil.round(f, n, 6);
    }

    public static float round(float f, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(f));
        return bigDecimal.setScale(n, n2).floatValue();
    }

    public static String round(String string, int n) {
        return MathUtil.round(string, n, 6);
    }

    public static String round(String string, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal.setScale(n, n2).toString();
    }

    public static int ceil(double d) {
        return (int)Math.ceil(d);
    }
}

