/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.springframework.util.Assert;

public class ReflectionUtils {
    private static Log a = LogFactory.getInstance(ReflectionUtils.class);

    public static Object invokeGetterMethod(Object object, String string) {
        String string2 = StringUtils.capitalize((String)string);
        String string3 = new StringBuilder(19).append("get").append(string2).toString();
        return ReflectionUtils.invokeMethod(object, string3, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object object, String string, Object object2) {
        ReflectionUtils.invokeSetterMethod(object, string, object2, null);
    }

    public static void invokeSetterMethod(Object object, String string, Object object2, Class<?> clazz) {
        Class<?> clazz2 = clazz != null ? clazz : object2.getClass();
        String string2 = StringUtils.capitalize((String)string);
        String string3 = new StringBuilder(19).append("set").append(string2).toString();
        ReflectionUtils.invokeMethod(object, string3, new Class[]{clazz2}, new Object[]{object2});
    }

    public static Object getFieldValue(Object object, String string) {
        Field field = ReflectionUtils.getAccessibleField(object, string);
        if (field == null) {
            Object object2 = object;
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(68).append("Could not find field [").append(string2).append("] on target [").append(object2).append("]").toString());
        }
        Object object3 = null;
        try {
            object3 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{0}", new Object[]{illegalAccessException.getMessage()});
        }
        return object3;
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        Field field = ReflectionUtils.getAccessibleField(object, string);
        if (field == null) {
            Object object3 = object;
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(68).append("Could not find field [").append(string2).append("] on target [").append(object3).append("]").toString());
        }
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{0}", new Object[]{illegalAccessException.getMessage()});
        }
    }

    public static Field getAccessibleField(Object object, String string) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)string, (String)"fieldName");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String string, Class<?>[] classArray, Object[] objectArray) {
        Method method = ReflectionUtils.getAccessibleMethod(object, string, classArray);
        if (method == null) {
            Object object2 = object;
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(69).append("Could not find method [").append(string2).append("] on target [").append(object2).append("]").toString());
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(exception);
        }
    }

    public static Method getAccessibleMethod(Object object, String string, Class<?> ... classArray) {
        Assert.notNull((Object)object, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int n) {
        Type type = clazz.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            String string = clazz.getSimpleName();
            a.warn((Object)new StringBuilder(51).append(string).append("'s superclass not ParameterizedType").toString());
            return Object.class;
        }
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        if (n >= typeArray.length || n < 0) {
            int n2 = typeArray.length;
            String string = clazz.getSimpleName();
            int n3 = n;
            a.warn((Object)new StringBuilder(78).append("Index: ").append(n3).append(", Size of ").append(string).append("'s Parameterized Type: ").append(n2).toString());
            return Object.class;
        }
        if (!(typeArray[n] instanceof Class)) {
            String string = clazz.getSimpleName();
            a.warn((Object)new StringBuilder(73).append(string).append(" not set the actual class on superclass generic parameter").toString());
            return Object.class;
        }
        return (Class)typeArray[n];
    }

    public static List<Object> convertElementPropertyToList(Collection<?> collection, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            for (Object obj : collection) {
                arrayList.add(PropertyUtils.getProperty(obj, (String)string));
            }
        }
        catch (Exception exception) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(exception);
        }
        return arrayList;
    }

    public static String convertElementPropertyToString(Collection<?> collection, String string, String string2) {
        List<Object> list = ReflectionUtils.convertElementPropertyToList(collection, string);
        return StringUtils.join(list, (String)string2);
    }

    public static Object convertStringToObject(String string, Class<?> clazz) {
        try {
            return ConvertUtils.convert((String)string, clazz);
        }
        catch (Exception exception) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(exception);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception exception) {
        if (exception instanceof IllegalAccessException || exception instanceof IllegalArgumentException || exception instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", exception);
        }
        if (exception instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException("Unexpected Checked Exception.", exception);
    }

    public static final <T> T getNewInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object, boolean bl) {
        try {
            FieldUtils.writeDeclaredStaticField(clazz, (String)string, (Object)object, (boolean)bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    static {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setUseLocaleFormat(true);
        dateConverter.setPatterns(new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
        ConvertUtils.register((Converter)dateConverter, Date.class);
    }
}

