/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.socket;

import com.hanweb.common.util.MapUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SocketClient {
    private static Log a = LogFactory.getInstance(SocketClient.class);
    private static final ConcurrentHashMap<String, SocketClient> b = new ConcurrentHashMap();
    private final ChannelFuture c;
    private final String d;
    private final int e;

    private SocketClient(ChannelFuture channelFuture, String string, int n) {
        this.c = channelFuture;
        this.d = string;
        this.e = n;
    }

    public static SocketClient getInstance(String string, int n) {
        return SocketClient.getInstance(string, n, null, null);
    }

    public static <T> SocketClient getInstance(String string, int n, Map<ChannelOption<T>, T> map) {
        return SocketClient.getInstance(string, n, map, null);
    }

    public static SocketClient getInstance(String string, int n, SocketClientCustomize socketClientCustomize) {
        return SocketClient.getInstance(string, n, null, socketClientCustomize);
    }

    public static <T> SocketClient getInstance(String string, int n, Map<ChannelOption<T>, T> map, SocketClientCustomize socketClientCustomize) {
        int n2 = n;
        String string2 = string;
        if (b.containsKey(new StringBuilder(27).append(string2).append(n2).toString())) {
            n2 = n;
            string2 = string;
            return b.get(new StringBuilder(27).append(string2).append(n2).toString());
        }
        SocketClient socketClient = null;
        try {
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)nioEventLoopGroup);
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            if (MapUtil.isNotEmpty(map)) {
                map.forEach((channelOption, object) -> bootstrap.option(channelOption, object));
            }
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void a(SocketChannel socketChannel) {
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, Delimiters.lineDelimiter()[0])});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                }

                protected /* synthetic */ void initChannel(Channel channel) throws Exception {
                    this.a((SocketChannel)channel);
                }
            });
            if (socketClientCustomize != null) {
                socketClientCustomize.build(bootstrap);
            }
            ChannelFuture channelFuture = bootstrap.connect(string, n).sync();
            socketClient = new SocketClient(channelFuture, string, n);
            n2 = n;
            string2 = string;
            b.put(new StringBuilder(27).append(string2).append(n2).toString(), socketClient);
        }
        catch (Exception exception) {
            a.info((Object)"create SocketClient error", (Throwable)exception);
        }
        return socketClient;
    }

    public void send(String string) {
        this.c.channel().writeAndFlush((Object)string);
        this.c.channel().writeAndFlush((Object)"\n");
    }

    public void close() {
        this.c.channel().close();
        int n = this.e;
        String string = this.d;
        b.remove(new StringBuilder(27).append(string).append(n).toString());
    }

    public static interface SocketClientCustomize {
        public void build(Bootstrap var1);
    }
}

